# 2.5 索引张量

我们已经知道`points[0]`返回一个张量，该张量包含`points`第一行所表示二维点。如果你需要获取一个包含除第一个点之外的所有点的张量怎么办？如果是应用在标准Python列表上，那么上述任务就可以很简单地用区间索引来实现：

``` python
some_list = list(range(6))
some_list[:]     # 所有元素
some_list[1:4]   # 第1（含）到第4（不含）个元素
some_list[1:]    # 第1（含）个之后所有元素
some_list[:4]    # 第4（不含）个之前所有元素
some_list[:-1]   # 最末尾（不含）元素之前所有元素
some_list[1:4:2] # 范围1（含）到4（不含），步长为2的元素
```

为了实现这个目标，你可以对PyTorch张量使用相同的表示，并且具有与NumPy和其他Python科学库一样的额外好处，即我们可以对张量的每个维使用区间索引：

``` python
points[1:]    # 第1行及之后所有行，（默认）所有列
points[1:, :] # 第1行及之后所有行，所有列
points[1:, 0] # 第1行及之后所有行，仅第0列
```

除了使用区间索引外，PyTorch还具有更强大的索引方式，被称为高级索引（advanced indexing）。