---
layout: markdown
title: Keybinds
---

## Region capture / Image editor

### Common

| Keybind | Description |
| --- | --- |
| <kbd>Hold left click</kbd> / <kbd>Insert</kbd> | Start region selection |
| <kbd>Delete</kbd> | Delete current shape |
| <kbd>Shift</kbd> + <kbd>Delete</kbd> | Delete all shapes |
| <kbd>Ctrl</kbd> + <kbd>C</kbd> | Copy position and size info |
| <kbd>Ctrl</kbd> + <kbd>V</kbd> | Paste image or text |
| <kbd>Ctrl</kbd> + <kbd>D</kbd> | Duplicate shape |
| <kbd>Ctrl</kbd> + <kbd>Z</kbd> | Undo |
| <kbd>Ctrl</kbd> + <kbd>Y</kbd> | Redo |
| <kbd>Arrow keys</kbd> | Move cursor / Move current shape |
| <kbd>Ctrl</kbd> + <kbd>Arrow keys</kbd> | Resize current shape from bottom right corner |
| <kbd>Alt</kbd> + <kbd>Arrow keys</kbd> | Resize current shape from top left corner |
| <kbd>Shift</kbd> + <kbd>Arrow keys</kbd> | Resize or move faster |
| <kbd>Home</kbd> | Move current shape top |
| <kbd>End</kbd> | Move current shape bottom |
| <kbd>Page up</kbd> | Move current shape up |
| <kbd>Page down</kbd> | Move current shape down |
| <kbd>Mouse wheel</kbd> | Change magnifier size |
| <kbd>Hold Ctrl</kbd> | Disables shape selection to allow drawing shape top of another shape |

##### While creating region

| Keybind | Description |
| --- | --- |
| <kbd>Release left click</kbd> / <kbd>Insert</kbd> | Finish region selection |
| <kbd>Right click</kbd> / <kbd>Delete</kbd> | Cancel region selection |
| <kbd>Hold Ctrl</kbd> | Move shape |
| <kbd>Hold Shift</kbd> | Proportional resizing |
| <kbd>Hold Alt</kbd> | Snap selection to preset sizes |

##### When cursor top of shape

| Keybind | Description |
| --- | --- |
| <kbd>Left click</kbd> / <kbd>Insert</kbd> | Select shape |
| <kbd>Hold left click</kbd> | Move shape |
| <kbd>Right click</kbd> / <kbd>Delete</kbd> | Delete shape |

### Region capture only

| Keybind | Description |
| --- | --- |
| <kbd>Esc</kbd> / <kbd>Right click</kbd> | Close region capture |
| <kbd>Tab</kbd> / <kbd>Middle click</kbd> | Switch between last region and last drawing tool |
| <kbd>Space</kbd> | Fullscreen capture |
| <kbd>1</kbd> / <kbd>2</kbd> / <kbd>3</kbd> ... <kbd>0</kbd> | Specific monitor capture |
| <kbd>~</kbd> | Active monitor capture |
| <kbd>Double left click</kbd> / <kbd>Enter</kbd> | If multi region mode is enabled then capture regions |

### Image editor only

| Keybind | Description |
| --- | --- |
| <kbd>Hold middle click</kbd> | Pan image |
| <kbd>Ctrl</kbd> + <kbd>Mouse wheel</kbd> | Zoom centered on cursor |
| <kbd>Ctrl</kbd> + <kbd>+</kbd> | Zoom in |
| <kbd>Ctrl</kbd> + <kbd>-</kbd> | Zoom out |
| <kbd>Ctrl</kbd> + <kbd>0</kbd> | Reset zoom |
| <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>0</kbd> | Zoom to fit |
| <kbd>Enter</kbd> | Close image editor and continue task with changes applied |
| <kbd>Right click</kbd> / <kbd>Space</kbd> | Close image editor and continue task without apply changes |
| <kbd>Esc</kbd> | Close image editor and cancel task |
| <kbd>Ctrl</kbd> + <kbd>S</kbd> | Save image |
| <kbd>Ctrl</kbd> + <kbd>Shift</kbd> + <kbd>S</kbd> | Save image as... |
| <kbd>Ctrl</kbd> + <kbd>C</kbd> | Copy image to clipboard |
| <kbd>Ctrl</kbd> + <kbd>U</kbd> | Upload image |
| <kbd>Ctrl</kbd> + <kbd>P</kbd> | Print image |

### Tools

| Keybind | Description |
| --- | --- |
| <kbd>M</kbd> | Select and move |
| <kbd>R</kbd> | Rectangle |
| <kbd>E</kbd> | Ellipse |
| <kbd>F</kbd> | Freehand |
| <kbd>L</kbd> | Line |
| <kbd>A</kbd> | Arrow |
| <kbd>O</kbd> | Text (Outline) |
| <kbd>T</kbd> | Text (Background) |
| <kbd>S</kbd> | Speech balloon |
| <kbd>I</kbd> | Step |
| <kbd>B</kbd> | Blur |
| <kbd>P</kbd> | Pixelate |
| <kbd>H</kbd> | Highlight |
| <kbd>C</kbd> | Crop image |
| <kbd>X</kbd> | Cut out |

## Pin to screen

| Keybind | Description |
| --- | --- |
| <kbd>Hold left click</kbd> | Move image |
| <kbd>Right click</kbd> / <kbd>Escape</kbd> | Close image |
| <kbd>Middle click</kbd> | Reset image |
| <kbd>Double click</kbd> | Minimize image |
| <kbd>Mouse wheel</kbd> / <kbd>+</kbd> <kbd>-</kbd> | Change image scale |
| <kbd>Ctrl</kbd> + <kbd>Mouse wheel</kbd> / <kbd>Ctrl</kbd> + <kbd>+</kbd> <kbd>-</kbd> | Change image opacity |
| <kbd>Ctrl</kbd> + <kbd>C</kbd> | Copy image |