/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;

    public OracleMultiPhaseArgs() {
    }

    public OracleMultiPhaseArgs(int n, int n2, Vector vector, Vector vector2) {
        if (n2 <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
        } else if (!vector.isEmpty() && !vector2.isEmpty() && vector2.size() == n2 && vector.size() == 3 * n2) {
            this.action = n;
            this.nsites = n2;
            this.xids = vector;
            this.dbLinks = vector2;
        }
    }

    public OracleMultiPhaseArgs(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataInputStream.readInt();
            this.nsites = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n2];
            int n3 = dataInputStream.read(byArray2, 0, n2);
            int n4 = 0;
            while (n4 < this.nsites) {
                int n5 = dataInputStream.readInt();
                byte[] byArray3 = new byte[n5];
                int n6 = dataInputStream.read(byArray3, 0, n5);
                this.xids.addElement(new Integer(n));
                this.xids.addElement(byArray2);
                this.xids.addElement(byArray3);
                String string = dataInputStream.readUTF();
                this.dbLinks.addElement(string);
                ++n4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] byArray = null;
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.action);
            dataOutputStream.writeInt(this.nsites);
            int n2 = 0;
            while (n2 < this.nsites) {
                String string = (String)this.dbLinks.elementAt(n2);
                int n3 = (Integer)this.xids.elementAt(n2 * 3);
                byte[] byArray2 = (byte[])this.xids.elementAt(n2 * 3 + 1);
                byte[] byArray3 = (byte[])this.xids.elementAt(n2 * 3 + 2);
                if (n2 == 0) {
                    n = n3;
                    byArray = byArray2;
                    dataOutputStream.writeInt(n3);
                    dataOutputStream.writeInt(byArray2.length);
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                }
                dataOutputStream.writeInt(byArray3.length);
                dataOutputStream.write(byArray3, 0, byArray3.length);
                dataOutputStream.writeUTF(string);
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        OracleLog.print(this, 256, 16, 64, "-------printMPArgs entry-------");
        OracleLog.print(this, 256, 16, 64, "  action = " + this.action);
        OracleLog.print(this, 256, 16, 64, "  nsites = " + this.nsites);
        int n = 0;
        while (n < this.nsites) {
            String string = (String)this.dbLinks.elementAt(n);
            int n2 = (Integer)this.xids.elementAt(n * 3);
            byte[] byArray = (byte[])this.xids.elementAt(n * 3 + 1);
            byte[] byArray2 = (byte[])this.xids.elementAt(n * 3 + 2);
            OracleLog.print(this, 256, 16, 64, "  fmtid  [" + n + "] = " + n2);
            OracleLog.print(this, 256, 16, 64, "  gtrid  [" + n + "] = ");
            this.printByteArray(byArray);
            OracleLog.print(this, 256, 16, 64, "  bqual  [" + n + "] = ");
            this.printByteArray(byArray2);
            OracleLog.print(this, 256, 16, 64, "  dblink [" + n + "] = " + string);
            ++n;
        }
        OracleLog.print(this, 256, 16, 64, "-------printMPArgs return-------");
    }

    private void printByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(byArray[n] + " ");
            ++n;
        }
        OracleLog.print(this, 256, 16, 64, "         " + stringBuffer.toString());
    }
}

