# SpotifyBigPicture - Presets
![Preset Selection](https://i.imgur.com/YU2dXEz.png)

Presets are the recommended way to customize the app. They're combinations of multiple settings (see [here](https://github.com/Selbi182/SpotifyBigPicture/blob/master/SETTINGS.md)) that form a unique identity and purpose. There's no harm done in just switching between presets at any time, so feel free to experiment until you find your desired style!

Here's a list of every preset along with an example screenshot (thank you, Rammstein):

### Default Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-default.png)
![Default Mode](https://i.imgur.com/bZfvmqF.png)

The default mode: a balanced design that aims to present as much information as possible about the current track (along with its artwork) without compromising on visual appeal

### Split-Panel Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-split-text.png)
![Split-Panel Mode](https://i.imgur.com/Tr0qq7u.png)

Puts the current track information on the left and the tracklist on the right. Disables the artwork and instead only dimly displays it in the background

### Tracklist Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-tracklist.png)
![Tracklist Mode](https://i.imgur.com/YFmMLRq.png)

Disables the artwork and instead only dimly displays it in the background, as well as the main content. Doing this opens up more room for the tracklist, which becomes centered. Also disables some lesser useful information

### Compact Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-compact.png)
![Compact Mode](https://i.imgur.com/1Sl5R2Y.png)

Similar to the default mode, but the artwork is on the right and a little smaller, opening up slightly more room for the main content

### XL-Artwork Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-xl-artwork.png)
![XL-Artwork Mode](https://i.imgur.com/f3KVGAe.png)

The artwork is stretched to its maximum possible size. Apart from that, only the current track, the tracklist, and the progress bar are displayed

### Vintage Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-vintage.png)
![Big Current-Track Mode](https://i.imgur.com/irAleYD.png)

A preset inspired by the original Spotify layout on Chromecast. The main content will be displayed below the artwork, the tracklist is disabled, the background is only a gradient color

### Big Current-Track Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-big-current-song.png)
![Big Current-Track Mode](https://i.imgur.com/BtuKduc.png)

Only shows the current track's title, artist and release in an extra large manner. The tracklist is disabled, the artwork is moved to the background

### Artwork-Only Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-artwork-only.png)
![Artwork-Only Mode](https://i.imgur.com/4tQTwmE.png)

Just displays the artwork on a gradient background, literally nothing else

### Vertical Mode
![Preset Thumbnail](https://raw.githubusercontent.com/Selbi182/SpotifyBigPicture/master/src/main/resources/static/design/img/presets/preset-vertical.png)
![Vertical Mode](https://i.imgur.com/2pQQsfn.png)

A preset optimized (only) for portrait mode. The main content will be displayed below the artwork. Don't use this preset on widescreen monitors, as it will likely break everything