# 💘 Dating app
### Built with Node, React, Postgres, Socket.io & Material-UI

## The project

Matcha is a dating app with the following features:
* 🌈 non-binary gender & sexual orientation choices
* 💘 matching algorithm based on preferences, distance, common interests and popularity rates
* 🛎 real-time notifications
* 💌 chat
* 🚫 possibility to block or report a user

## How to quickly try it?

👉 The project is hosted on Heroku: https://maatcha.herokuapp.com/ 

💡 If you don't want to go through the sign-up process, here are a few login credentials you can use:
```
* maëlle16675 // xLDUD5AOSsLL2rs
* romain81397 // K1XZ_qxOGYsQnr1
* noémie36222 // ac3i707y193nqWs
```

## The stack
### Back
* [Node](https://nodejs.org/en/)
* [Express](https://expressjs.com/)
* [Postgres](https://www.postgresql.org/)
* [Socket.io](https://socket.io/) : real-time engine (chat + notifications)
* [AWS](https://aws.amazon.com/fr/s3/) : images hosting

### Front
* [React](https://reactjs.org/)
* [Material-Ui](https://material-ui.com/) : React UI framework

### API we used
* [Google maps](https://developers.google.com/maps/documentation/javascript/tutorial)
* [Mailjet](https://www.mailjet.com/)
* [Faker](https://github.com/marak/Faker.js/) : to generate fake profiles for the seed

## What it looks like

[![Dashboard](https://iili.io/Jfl9Xn.png)](https://freeimage.host/i/capture-decran-2020-03-30-123639.Jfl9Xn)
[![Profile](https://iili.io/Jfl3g4.png)](https://freeimage.host/i/capture-decran-2020-03-30-132035.Jfl3g4)
[![Search-matches](https://iili.io/JflHss.png)](https://freeimage.host/i/capture-decran-2020-03-30-130950.JflHss)
[![Chatroom](https://iili.io/JfldqG.png)](https://freeimage.host/i/capture-decran-2020-03-30-131939.JfldqG)
[![Notifications](https://iili.io/Jfl21f.png)](https://freeimage.host/i/capture-decran-2020-03-30-131952.Jfl21f)

## How we've been working
* 🗓 Planning the project and user stories on Trello : [The Project Board](https://trello.com/b/RLNAgAuw/matcha-launch)
* 🗄 Designing the database on dbdiagram.io
[![Database-diagram](https://iili.io/JfcVO7.png)](https://freeimage.host/i/capture-decran-2020-03-30-121118.JfcVO7)
* 🎨 Designing simple wireframes on Figma : [The Wireframes](https://www.figma.com/file/daD5AHhiB3XmfUPdi4PhsS/Matcha?node-id=0%3A1)

## Credits

👨🏻‍💻👩🏻‍💻Built and designed by [@yann120](https://github.com/yann120) & [@Segolene-Alquier](https://github.com/Segolene-Alquier/)
