---
layout: page
title: Style Guide
description: SeaGL Style Guide
nav: style_guide
body_id: style_guide
---

<div class="row style-guide"><div class="col-md-4 col-md-push-8" markdown="1">

## Contents

- [Design](#Design)
	- [The Logo](#TheLogo)
	- [Font Styles](#FontStyles)
	- [Color Palette](#ColorPalette)
	- [Color Usage](#ColorUsage)
	- [Design Assets](#DesignAssets)

</div><div class="col-md-8 col-md-pull-4" markdown="1">

## SeaGL Style Guide

The goal of this guide is to group the common effort on the creation of design materials for the Seattle GNU/Linux Conference. It describes best practices for creating new materials and applying the visual identity of the event.

## Design {#Design}

This section contains information about the visual elements of the conference, how to use them and best practices. All design assets are licensed under [CC BY-SA](https://creativecommons.org/licenses/by-sa/4.0/), unless otherwise specified.

### The Logo {#TheLogo}

Our logo is the most recognizable SeaGL symbol. Is composed of two elements: The low-poly seagull illustration with a circular two blue tone background and a gray ribbon underneath with the conference name.

As the logo is multicolored, we have limited background color options. White and the blue variations described on the color palette are the options for multiple context usage. Also, a special blue-white background with gold separation on the ribbon is used.

A minimum clear space around the logo is required, about 50% of the diameter on each side. Using with small size are not recommended, due to the logo complexity.

For the online events, there is a special version where the seagull is with a microphone. It follows the same restrictions as the classic version.

The logo images may be used without advance permission, subject to the following requirements:

- The use is only in connection with promoting the SeaGL conference.
- The use does not imply sponsorship or endorsement by the SeaGL conference.
- Where possible, the logo hyperlinks to https://seagl.org or an appropriate page on that site.
- The logo images are not altered, except to proportionally resize.

#### Usage examples

- Blue Backgrounds
![Blue background logo usage example](/img/style_guide/logo_usage_example_1.png)

- Special "badge" background and other formats, with spacing
![Special badge background and other formats logo usage example](/img/style_guide/logo_usage_example_2.png)

- White and White 2 backgrounds
![White and White 2 backgrounds logo usage example](/img/style_guide/logo_usage_example_3.png)

## Font Styles {#FontStyles}

The SeaGL typography is one of the core elements that defines the conference design style. We use two fonts, [Dosis](https://github.com/impallari/Dosis) and [Lato](https://www.latofonts.com/), according to the following:

- Dosis (Regular): Applied on headers / titles; capitals only.
- Lato: Other text elements, like text body.

Text alignment can vary by application, the important thing is to stay good in context.

### Usage Examples

- Blog post
![Blog post example](/img/style_guide/blog_post_example.png)

- Social Media conference call:
![Social media conference call example](/img/style_guide/social_media_conference_call_example.png)

- Print handbill:
![Print handbill example](/img/style_guide/handbill_example.png)

## Color Palette {#ColorPalette}

Any used colors should be taken either directly from the palette or be derived from the palette:

| Color                                                                       | HEX       | RGB               | CMYK               |
|-----------------------------------------------------------------------------|-----------|-------------------|--------------------|
| <span class="swatch" style="color: #1D7193;"></span> Tidal Blue             | `#1D7193` | `RGB 29 113 147`  | `CMYK 82 40 25 14` |
| <span class="swatch" style="color: #0C5A73;"></span> Puget Sound            | `#0C5A73` | `RGB 12 90 115`   | `CMYK 87 46 34 25` |
| <span class="swatch" style="color: #074558;"></span> Deep Ocean             | `#074558` | `RGB 7 69 88`     | `CMYK 89 47 40 47` |
| <span class="swatch" style="color: #FCB320;"></span> French Fry Gold        | `#FCB320` | `RGB 252 179 32`  | `CMYK 2 34 89 0`   |
| <span class="swatch" style="color: #B1742A;"></span> Wet Sand               | `#B1742A` | `RGB 177 116 42`  | `CMYK 24 53 88 17` |
| <span class="swatch" style="color: #FFFCF7;"></span> Bread For Screaming At | `#FFFCF7` | `RGB 255 252 247` | _digital only_     |
| <span class="swatch" style="color: #FFFFFF;"></span> Feather White          | `#FFFFFF` | `RGB 255 255 255` | `CMYK 0 0 0 0`     |
| <span class="swatch" style="color: #E0E0E0;"></span> Brave Gull             | `#E0E0E0` | `RGB 224 224 224` | `CMYK 0 0 0 16`    |
| <span class="swatch" style="color: #CCCCCC;"></span> Gloomy Sky             | `#CCCCCC` | `RGB 204 204 204` | `CMYK 0 0 0 23`    |
| <span class="swatch" style="color: #B3B3B3;"></span> Stormy Sky             | `#B3B3B3` | `RGB 179 179 179` | `CMYK 0 0 0 39`    |
| <span class="swatch" style="color: #565656;"></span> Storm Cloud            | `#565656` | `RGB 86 86 86`    | `CMYK 0 0 0 80`    |
| <span class="swatch" style="color: #0D0D0D;"></span> Penguin Black          | `#0D0D0D` | `RGB 13 13 13`    | `CMYK 0 0 0 100`   |

### Color palette overview

<figure class="palette-overview">
  <div style="background-color: #1D7193;" class="dark">Tidal Blue<br>#1D7193<br>RGB 29 113 147</div>
  <div style="background-color: #0C5A73;" class="dark">Puget Sound<br>#0C5A73<br>RGB 12 90 115</div>
  <div style="background-color: #074558;" class="dark">Deep Ocean<br>#074558<br>RGB 7 69 88</div>
  <div style="background-color: #FCB320;" class="light">French Fry Gold<br>#FCB320<br>RGB 252 179 32</div>
  <div style="background-color: #B1742A;" class="dark">Wet Sand<br>#B1742A<br>RGB 177 116 42</div>
  <div style="background-color: #FFFCF7;" class="bordered light">Bread For Screaming At<br>#FFFCF7<br>RGB 255 252 247</div>
  <div style="background-color: #FFFFFF;" class="bordered light">Feather White<br>#FFFFFF<br>RGB 255 255 255</div>
  <div style="background-color: #E0E0E0;" class="light">Brave Gull<br>#E0E0E0<br>RGB 224 224 224</div>
  <div style="background-color: #CCCCCC;" class="light">Gloomy Sky<br>#CCCCCC<br>RGB 204 204 204</div>
  <div style="background-color: #B3B3B3;" class="light">Stormy Sky<br>#B3B3B3<br>RGB 179 179 179</div>
  <div style="background-color: #565656;" class="dark">Storm Cloud<br>#565656<br>RGB 86 86 86</div>
  <div style="background-color: #0D0D0D;" class="dark">Penguin Black<br>#0D0D0D<br>RGB 13 13 13</div>
</figure>

## Color Usage {#ColorUsage}

The color usage must respect others elements rules, like the logo. Mainly, the blue and white variations are used for backgrounds.

The *White 2* color is used in digital material with focus on text, such as the website, for better reading.

Gold is applied to action links and to contrast with the blue / background, depending on the situation.

### Usage examples

- Website Ribbon
![Website color palette example](/img/style_guide/website_ribbon_example.png)

- Profile Banner
![Social media banner example](/img/style_guide/social_media_banner_example.png)

## Design Assets {#DesignAssets}

All design materials are available in the [design folder](https://github.com/SeaGL/outreach/tree/main/design) inside the [SeaGL outreach](https://github.com/SeaGL/outreach) repository.

Specific materials and other quick reference files:

- [Logo (png)](#)
- [Logo (svg)](https://github.com/SeaGL/outreach/blob/main/design/logo/seagl_logo.svg)
- [Logo with mic (png)](#)
- [Logo with mic (svg)](#)
- [Color Palette file](#)
- [Templates](#)

</div></div>
