---
layout: page
redirect_from:
  - /chat
title: Community Chat
---

# Community Chat

Please join our community space at [#SeaGL:seagl.org] in Matrix.
{: .lead}

## About Matrix

[Matrix] is a modern chat system that is decentralized similarly to email—your account exists at the service provider of your choice, but you can communicate seamlessly across providers.

### Getting started

As with email, the first step in using Matrix is choosing a service provider. Many [options][Matrix options] are available, but we recommend:

  - creating your account at [Matrix*.org*][Matrix.org], a public service operated by a non-profit foundation
  - connecting using [Element], an open source application for a variety of platforms

In practice this means:

 1. Open the [Element web interface]{:target="_blank" rel="noopener"}.
 1. Follow the prompts to create an account.
 1. Choose <samp>Explore rooms</samp>, enter `#SeaGL:seagl.org`, then choose <samp>Join</samp>.

### Help

Please feel free to reach out to <matrix-help@seagl.org> if you have any trouble connecting.

<details markdown="1"><summary>What about IRC?</summary>

In the past SeaGL’s community chat was [bridged][Matrix bridges] between Matrix and IRC, but maintaining this was technically challenging and it fell into disuse. If you’d like to help restore it, please get in touch! To coordinate without using Matrix, please contact {{ site.custom.a.email.participate }}.

</details>

## Video meetings

Some rooms such as [Office Hours] are set up for optional video meetings. In addition to text chat via Matrix, a shared video call is available via [Jitsi Meet]. To access it:

  - A **link** to the video call will be available in the topic of the Matrix room. You can join the call by opening the link in your web browser or Jitsi Meet app.
  - If you’re using [Element], the video call will be **integrated** into your view of the Matrix room.


[#SeaGL:seagl.org]: https://matrix.to/#/#SeaGL:seagl.org
[Element]: https://element.io/
[Element web interface]: https://app.element.io/
[Jitsi Meet]: https://jitsi.org/jitsi-meet/
[Matrix]: https://matrix.org/
[Matrix.org]: https://matrix.org/about/
[Matrix bridges]: https://matrix.org/bridges/
[Matrix options]: https://matrix.org/try-matrix/
[Office Hours]: /cfp
