---
layout: page
nav: maps
body_id: maps
title: 2023 Maps
---

# Maps & Directions

## Conference Venue

<div class="row">
<div class="col-xs-12 col-md-6 col-md-push-6"><div class='venue-map' id='maplibre-root'></div></div>
<div class="col-xs-12 col-md-6 col-md-pull-6" markdown="1">

### Location

The HUB  
University of Washington  
Seattle, WA, USA

### Driving Directions via I-5 N

#### via **exit 168B** for WA-520

1. Take **exit 168B** for WA-520 towards Bellevue/Kirkland.
1. Follow WA-520 and **take exit** toward Montlake Blvd//Univ Of Wash.
1. Use left two lanes and **turn left** onto Montlake Blvd E.
1. Follow Montlake Blvd E and **turn slightly left** onto 25th Ave NE.
1. Follow 25th Ave NE and **turn left** onto Pend Oreille Road NE.
1. Follow Pend Oreille Road NE and **pay for parking**.
1. Follow Pend Oreille Road NE and **turn left** onto Mason Rd.
1. Follow Mason Rd and **park** in the Padelford Parking Garage.

#### via **exit 169** onto NE 45th St

1. Take **exit 169** onto NE 45th St.
1. Follow signs for NE 45th St and **turn right** onto NE 45th St.
1. Follow NE 45th St and **turn right** onto Memorial Way NE.
1. Follow Memorial Way NE and **pay for parking**.
1. **Turn left** onto E Stevens Way NE.
1. Follow E Stevens Way NE and **turn left** onto Pend Orelle Road NE.
1. Follow Pend Oreille Road NE and **turn right** onto Mason Rd.
1. Follow Mason Rd and **park** in the Padelford Parking Garage.

*[I-5 N]: Interstate 5 Northbound

### Parking

There are several on-campus parking options located near the HUB. We recommend
the [Padelford Parking Garage] if there is space. Otherwise, the [E18 lot] is
more affordable and available. Street parking off-campus can be hard to come by
and is usually time-constrained.

[Additional Directions & Parking Details](https://hub.washington.edu/about/plan-your-visit/#directions)

[E18 lot]: https://transportation.uw.edu/park/visitor/self-serve
[Padelford Parking Garage]: https://www.washington.edu/maps/#!/padelford-garage-n16-n18-n20-n21

</div></div><div class="row"><div class="col-xs-12" markdown="1">

### Indoor map

![Map of HUB floors 1, 2, and 3](/img/maps/2023/indoor.png){: width="848" height="960"}

</div></div>

<link href="/css/vendor/maplibre-gl-3.1.0.css" rel="stylesheet" />
<script src="/js/vendor/maplibre-gl-3.1.0.js"></script>
<script>
  const map = new maplibregl.Map({
    boxZoom: false,
    center: [-122.305476, 47.655322],
    container: "maplibre-root",
    dragRotate: false,
    maxBounds: [[-122.4375, 47.5683], [-122.2404, 47.6902]],
    maxZoom: 14 + 3,
    minZoom: 11,
    pitchWithRotate: false,
    style: "/map-data/uw/osm-liberty/styles.custom.json",
    touchZoomRotate: false,
    zoom: 15.5
  });

  map.addControl(new maplibregl.NavigationControl({ showCompass: false }));

  new maplibregl.Marker({ color: "#1d7193" })
    .setLngLat([-122.305476, 47.655322])
    .addTo(map);
</script>
