---
layout: page
nav: maps
body_id: maps
title: 2019 Maps
---

# Maps & Directions

## Conference Venue

<div class="row">
<div class="col-xs-12 col-md-6 col-md-push-6"><div class='venue-map' id='maplibre-root'></div></div>
<div class="col-xs-12 col-md-6 col-md-pull-6" markdown="1">

Seattle Central College  
1701 Broadway  
Seattle, WA 98122

### Driving Directions

#### via I-5 N

1. Take **exit 166** (under the Washington State Convention Center) onto Olive Way.
1. Follow Olive Way and **turn right** onto Denny Way.
1. Follow Denny Way up the hill and **turn right** onto Broadway.
1. Follow Broadway and **turn right** onto Pine.
1. Go one block down to the parking garage located at Harvard & Pine.

#### via I-5 S

1. Take **exit 166** onto Stewart.
1. Follow Stewart and **turn left** onto Denny Way.
1. Follow Denny Way up the hill and **turn right** onto Broadway.
1. Follow Broadway and **turn right** onto Pine.
1. Go one block down to the parking garage located at Harvard & Pine.

*[I-5 N]: Interstate 5 Northbound
*[I-5 S]: Interstate 5 Southbound

### Parking

There are several private parking lots located near the front entrance at 1701
Broadway Ave. or on Harvard Avenue, which parallels Broadway behind the school.
There also is metered 2-hour street parking.

Please use street parking or private parking. SCC's lots are for teachers and
students.

Here is a [crude map of the parking around SCC](/img/maps/2019/Street_Parking_Map.png).

</div></div><div class="row"><div class="col-md-4" markdown="1">

### First Floor: Expo Hall

![First Floor](/img/maps/2019/SCC_First_Floor_Expo.png){: style="max-height: 75rem;"}

</div><div class="col-md-8" markdown="1">

### Third Floor: Sessions

![Third Floor](/img/maps/2019/SCC_Third_Floor_Sessions.png)

</div></div>

<link href="/css/vendor/maplibre-gl-3.1.0.css" rel="stylesheet" />
<script src="/js/vendor/maplibre-gl-3.1.0.js"></script>
<script>
  const map = new maplibregl.Map({
    boxZoom: false,
    center: [-122.32152, 47.61642],
    container: "maplibre-root",
    dragRotate: false,
    maxBounds: [[-122.4162, 47.5799], [-122.2234, 47.6529]],
    maxZoom: 16 + 2,
    minZoom: 12,
    pitchWithRotate: false,
    style: "/map-data/scc/osm-liberty/styles.custom.json",
    touchZoomRotate: false,
    zoom: 15
  });

  map.addControl(new maplibregl.NavigationControl({ showCompass: false }));

  new maplibregl.Marker({ color: "#1d7193" })
    .setLngLat([-122.32116, 47.61623])
    .addTo(map);
</script>
