---
layout: page
nav: maps
body_id: maps
title: 2017 Maps
---

# SeaGL 2017 Directions and Maps

## SCC Address

1701 Broadway Seattle, WA 98122 - [View in Google Maps](https://maps.google.com/maps?q=Seattle+Central+College,+Broadway,+Seattle,+WA&hl=en&ll=47.616376,-122.321348&spn=0.002839,0.005917&sll=47.616135,-122.320806&sspn=0.001427,0.002958&oq=SCC,+&t=m&z=18)

<div id="map_canvas" style="width: 900px; height: 400px;"></div>

## Driving Directions

### From Interstate 5 Northbound

Take Olive Way/Denny Way Exit 166 (under the Washington State Convention and
Trade Center) and follow Olive Way east to Denny Way and turn right. Go up the
hill and turn right on Broadway. Follow Broadway south to Pine, turn right, and
go one block west to the Parking Garage located at Harvard and Pine.

### From Interstate 5 Southbound

Follow the Madison Street/Convention Center Exit 165, making a right hand turn
onto Madison. Get into the left lane and turn left at Boren. Follow Boren north
until Pine Street, and turn right at Pine going east. Follow Pine Street east
until Harvard Ave. Turn left onto Harvard, then make an immediate left turn into
the Harvard Ave. parking garage.

## Parking

There are several private parking lots located near the front entrance at 1701
Broadway Ave. or on Harvard Avenue, which parallels Broadway behind the school.
There also is metered 2-hour street parking.

Please use street parking or private parking. SCC's lots are for teachers and
students.

Here is a crude map of the parking around SCC: [Street_Parking_Map.png](/img/maps/2017/Street_Parking_Map.png)

## Session Map

### First Floor - Expo Hall

![First Floor](/img/maps/2017/SCC_First_Floor_Sessions.png)

### First/Third/Fifth Floor - Speaking Sessions

![First/Third/Fifth Floor](/img/maps/2017/SSC_apres_deluge_sessions.JPG)

<script type='text/javascript' src="//maps.googleapis.com/maps/api/js?v=3.exp&key={{ site.custom.maps.google.apikey }}"></script>
<script type='text/javascript'>
    $(function(){
        var mapOptions = {
            zoom: 17,
            center: new google.maps.LatLng(47.616248,-122.321426),
            mapTypeId: google.maps.MapTypeId.HYBRID
        };
        gMap = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

        var marker = new google.maps.Marker({
            position: new google.maps.LatLng(47.616248,-122.321426),
            map: gMap,
            title: 'SeaGL @ SCC'
        });

        var contentString = '<div id="content">'+
            '<div id="siteNotice">'+
            '</div>'+
            '<h1 id="firstHeading" class="firstHeading">SeaGL @ SCC</h1>'+
            '<div id="bodyContent">'+
            '<p>1701 Broadway Seattle, WA 98122</p>'+
            '</div>'+
            '</div>';

        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });

        google.maps.event.addListener(marker, 'click', function() {
            infowindow.open(gMap, marker);
        });
    });
</script>
