---
layout: page
nav: home
body_id: home
title: Seattle GNU/Linux Conference
description: SeaGL is a grassroots technical conference dedicated to spreading awareness and knowledge about the GNU/Linux community and free/libre/open-source software/hardware.
---

<div class="row"><div class="col-md-4 col-md-push-8" markdown="1">

## About

Founded in 2013, SeaGL (the *Seattle GNU/Linux Conference*) is a free—as in freedom and tea—grassroots technical summit dedicated to spreading awareness and knowledge about free / libre / open source software, hardware, and culture.

SeaGL strives to be welcoming, enjoyable, and informative for professional technologists, newcomers, enthusiasts, and all other users of free software, regardless of their background knowledge; providing a space to bridge these experiences and strengthen the free software movement through mentorship, collaboration, and community.

### When & where

**{{ site.custom.dates }}, {{ site.custom.year }}** at {{ site.custom.a.location }} and online.

### Attend

SeaGL is **free to attend**, and you **do not need to register**—just show up!

You may attend SeaGL without identifying yourself, and you are encouraged to do so to protect your privacy.

<!--
You may optionally [register]({{ site.custom.url.register }}).
This gives us more accurate estimates of attendance, which help us raise money for the conference.
The registration system is free / libre / open source software and we promise to protect your data.
-->

All attendees must abide by the [Code of Conduct](/coc), and if participating in-person, the [Health and Safety Policy](/health).

More details about how to attend can be found [here](/attend).

### Stay informed

Sign up for our low-traffic [announcement mailing list]({{ site.custom.url.mailing_list.seagl_announce }}) or subscribe to our [RSS news feed](/feed.xml).

---
{:.hidden-md .hidden-lg}

</div><div class="col-md-8 col-md-pull-4">

{% include recent_news.html %}

</div></div><div class="row"><div class="col-md-4" markdown="1">

## Contact

### Chat

Please join us in [Matrix](/meet).

### Social Media

{{ site.custom.a.social.mastodon}}
| {{ site.custom.a.social.pixelfed}}
| {{ site.custom.a.social.twitter}}
| {{ site.custom.a.social.facebook}}
| {{ site.custom.a.social.youtube}}

An overview of SeaGL’s social media activity is available in [`#social-media:seagl.org`](https://matrix.to/#/#social-media:seagl.org).

### Email

{{ site.custom.a.email.participate }} | {{ site.custom.a.email.press }}  
or join the {{ site.custom.a.mailing_list.seagl_announce }}.

</div><div class="col-md-4" markdown="1">

## Exhibitors

We will have a small hall available for in-person exhibitors as well as virtual expo hall space available at SeaGL 2024.
Free/libre/open-source software/hardware projects and non-profit organizations may request gratis space.
There are several paid sponsorship levels and add-ons for other entities.
If your group would like to exhibit at SeaGL, please
{%- if site.custom.url.prospectus %} review our <a href="{{ site.custom.url.prospectus }}">Partnership/Sponsor Prospectus</a> or{% endif %}
send an email to {{ site.custom.a.email.sponsor }} for more information.

</div><div class="col-md-4" markdown="1">

## Sponsorship

We can't do what we need to do without the support of the community.
If you would like to offer financial support but don't need an exhibit table, please send an email to {{ site.custom.a.email.sponsor }}.

## Donate now

Our fiscal sponsor, [**Open Source Initiative**](https://opensource.org), set up a donation page enabling you to support SeaGL.
These contributions may be tax deductible as OSI is a 501(c)(3) non-profit organization.
Thank you for your support!

{{ site.custom.a.donate }}

</div></div>
