---
layout: page
title: Health and Safety Policy
description: Health and Safety Policy
nav: health_and_safety
body_id: health
redirect_from:
  - /covid19
  - /COVID19
  - /covid-19
  - /COVID-19
  - /health
  - /Health
  - /safety
  - /Safety
---

# Health and Safety Policy

SeaGL, the Seattle GNU/Linux Conference, is more than just a gathering; it is a community. As such, we all have a duty to protect one another and keep our community safe.

As we returned to hosting in-person activities in 2023, SeaGL added a Health and Safety Policy. This policy acts as a framework for us to respect the health of our fellow attendees during the event, and to ensure that we can continue meeting safely at events into the future.

***NOTICE:*** This was the **2024** policy. We will release an update for 2025 no later than six (6) months prior to the event.

Our Health and Safety Policy encourages facial coverings in spaces where distancing cannot be maintained, expects full vaccination and voluntary testing by attendees, and includes mitigations in the form of outdoor ventilation, as suggested by the [Public Health Pledge’s badging standard](https://publichealthpledge.com/badging).

Any policy updates we publish will not be weakened before the 2024 event held on November 8th and 9th.


## Definitions

- **Expect** means that a measure is a condition of entry and considered to be reasonable conduct at the event. Reports of non-compliance will be treated as incidents of Harassment (as referred to in our [Code of Conduct](/coc)) and may result in removal from the conference without recourse.
- **Encourage** means that a measure is voluntary, however, compliance will improve the health and safety standards for attendees.
- **Commit** means that the organizers will ensure that a measure will be in place during the conference.
- **Strive** means that the organizers will attempt to set a measure in place during the conference.
- **Attendees** includes people with paid or unpaid tickets to attend the conference, people entering conference restricted space such a presentation rooms, all presenters, vendors engaged by, or on behalf of SeaGL, as well as volunteers and organizers during each scheduled conference day, or on setup days in spaces where physical distancing cannot be maintained.


## Masking

We _expect_ attendees, aside from the active presenter, to wear masks (as described in the "facial coverings" paragraph below) in all presentation spaces, including the keynote auditorium.

We _expect_ facial coverings to be made of a tight-knit, non-permeable material that completely covers the nose and mouth. Facial coverings should should be of N95 or equivalent rating, [as recommended by the United States Centers for Disease Control (CDC)](https://www.cdc.gov/coronavirus/2019-ncov/prevent-getting-sick/types-of-masks.html). These are particularly effective at reducing exposure to viruses, allergens, and other pollutants that may cause COVID/flu-like symptoms.

We _encourage_ attendees to wear masks (as described in the "facial coverings" paragraph above) in all indoor spaces, any spaces where physical distancing cannot be maintained, and any other spaces designated by the conference organizers.

We _commit_ to having a supply of high-quality facial coverings at the event and will supply any attendee who needs one, free of charge.

We _commit_ to providing outdoor space for attendees who wish to eat, drink, or socialize without wearing a facial covering.

The first two (2) violations of this masking policy by a participant will result in verbal or written warnings. A third (3rd) violation will result in removal from the conference with no recourse.

Note that there are spaces on our venue’s premises which are not subject to our policy.


## Vaccination

We _expect_ all non-exempt attendees to have received a complete primary series of COVID-19 vaccinations.

We _encourage_ attendees to receive up-to-date COVID-19 and influenza vaccine boosters.

We will **not** verify vaccination status due to SeaGL's commitment to attendance without identification or registration.

We _commit_ to providing a method for attendees to voluntarily display their vaccination status.

We _encourage_ anyone with concerns about the available COVID-19 vaccines review the [CDC Myths and Facts](https://www.cdc.gov/coronavirus/2019-ncov/vaccines/facts.html) web page.


## Testing

We _encourage_ attendees to have completed a COVID-19 PCR test within 72 hours or a rapid antigen test within three (3) hours before attending the event.

We _encourage_ attendees to test daily during the event, during travel days to or from Seattle, and on the fifth (5th) day following the conclusion of the event to account for an incubation period.

We _strive_ to offer COVID-19 rapid antigen tests for those with financial need, including financial aid recipients.


## Ventilation

We _commit_ to using CO₂ monitors as a proxy for ventilation levels throughout the conference.

We _strive_ to prioritize ventilation of event spaces through actions such as keeping doors and windows open.

We _strive_ to maintain attendance that is limited below physical space capacities.


## Physical Distancing

We _expect_ attendees to respect one another's boundaries, especially if a request for distancing is made.

We _encourage_ attendees to maintain six (6) feet of open space between one another where able.


## Sanitation

We _expect_ attendees wash or sanitize their hands frequently.

We _commit_ to providing hand sanitizer in all conference spaces.


## Illness

We _expect_ attendees will not attend the conference if their presence would create an increased risk of exposure to communicable diseases (such as COVID-19) to their fellow attendees.

Increased risk factors include:

- Experiencing known COVID-19 or flu-like symptoms, in ways that are unusual to you
- Testing positive to COVID-19 during the conference, or before the conference without subsequently testing negative (for example, by two (2) non-positive rapid antigen tests taken 48 hours apart, or a negative PCR test)
- Experiencing extended close contact with someone who has tested positive to COVID-19, influenza, or other communicable respiratory infections
- Any significant risk factor identified by the State of Washington or United States Public Health authorities

We _commit_ to offer a refund, should we have a paid ticket option, prorated to the number of full days that the attendee was unable to attend due to illness.


## Reporting

We _expect_ attendees who test positive for COVID-19, influenza, or other communicable respiratory infections within the seven (7) days following the event to inform the organizing team, in order that other attendees can be notified and adopt appropriate risk management.

We _commit_ to providing an anonymous reporting channel, and not identifying attendees who report testing positive.


## Alternatives

We _commit_ to providing remote participation options for presentations.

We _strive_ to provide remote participation options for social events.

---

This Health and Safety Policy is based in part on North Bay Python's found here, <https://2024.northbaypython.org/health-and-safety-policy>, and is available under the [Creative Commons Attribution-ShareAlike (CC BY-SA) License](https://creativecommons.org/licenses/by-sa/4.0/).

We are eager to consider any additions to this Health and Safety Policy that you might find valuable, to better support you or others, or to clarify our objective.

Thank you!
