---
layout: page
title: Code of Conduct
description: Code of Conduct
nav: code_of_conduct
body_id: coc
redirect_from:
  - /coc
  - /CoC
---

# Code of Conduct

**Contact:** <CoC@seagl.org>

SeaGL is dedicated to providing a harassment-free conference experience for everyone. We do not tolerate harassment of conference staff, volunteers, presenters, attendees, exhibitors, and participants in any form. Conference participants violating these rules may be sanctioned or expelled from the conference, without a refund, at the discretion of the conference organizers.

This Code of Conduct (CoC) applies during the entire conference and in any conference associate space, online or otherwise. Which includes, but is not limited to: the conference venue, presentation spaces, exhibition hall, evening gatherings, social media, Google groups, email lists, and online channels (Matrix or IRC).

**Harassment includes any of the following and/or any action that discriminates against an individual based on gender, gender identity and expression, sexual orientation, disability, physical appearance, body size, nationality, race, citizenship and/or refugee status, religion, or employment status:**

  - Offensive verbal, written, or chat comments
  - Sustained disruption of talks or events
  - Offensive direct messages (DMs)
  - Deliberate intimidation
  - Stalking, unwelcome following
  - Sexual images in public spaces
  - Persistent unwelcome sexual attention
  - Any and all inappropriate physical contact
  - Unauthorized photography or recording without permission
  - Server based abuse (flooding, spamming, DoS attempts)

Please note, this list is not exhaustive. SeaGL staff and moderators will be available to triage any actions as they might occur, and to deploy moderation (sanctioning or expulsion) as needed. Participants asked to stop any harassing behavior are expected to comply immediately.

Sexual language and imagery are not appropriate at this conference. Exhibitors at the sponsor or vendor booths, or similar activities, are also subject to the anti-harassment policy. In particular, exhibitors should not use sexualized images, activities, or other material. Booth staff (including volunteers) should not use sexualized clothing/uniforms/costumes, or otherwise create a sexualized environment.

If you are being harassed, notice that someone else is being harassed, or have any other concerns, please contact a member of the conference staff immediately. Staff and moderators will be trained and on hand during the entire duration of the event to address any concerns. For any harassment that happens after the conference, staff members can be reached year-round by emailing <CoC@seagl.org>.

To respect the privacy of those involved and insulate any legal concerns, SeaGL's policy is to not make public statements about individual CoC cases. All CoC decisions are made collectively by the SeaGL CoC committee, or in the absence of a current committee, collectively by other committee organizing chairs of the SeaGL organization.

We strive to help our participants, and assist those experiencing harassment or intimidation, in feeling safe for the duration of the conference. We value your attendance!

---

This CoC is based in part on the template found here, <https://geekfeminism.wikia.org/wiki/Conference_anti-harassment/Policy>, and is available under the Creative Commons Zero License.

We are eager to consider any additions to this CoC that you might find valuable, to better support you or others, or to clarify our objective. Thank you!
