---
layout: page
redirect_from:
  - /attend-existing
title: Attend SeaGL 2024 Remotely
description: How to attend SeaGL 2024 with an existing Matrix account
---

# Attend with your Matrix account

The remote part of SeaGL's hybrid conference uses a Matrix homeserver operated by [Seattle Matrix](https://seattlematrix.org/). The whole conference is a series of rooms and subspaces in a Matrix space—it is primarily designed with [Element](https://element.io/)'s interface in mind. You can of course use your own preferred Matrix client—just bear in mind we won't be able to help you out as much.

Here's a button to get into the main conference space:

<div class="text-center">
  <p><a class="btn btn-primary btn-large" href="https://matrix.to/#/#SeaGL2024:seattlematrix.org">Join the SeaGL 2024 space</a></p>
</div>

Below are some tips on navigating the conference in Element. If you run into any trouble, you can always email <matrix-help@seagl.org> or find us in the [Info Booth](https://matrix.to/#/#2024-info-booth:seagl.org) room.

As a reminder, participation in any SeaGL space is subject to our [Code of Conduct](/code_of_conduct).


## Navigating spaces

Spaces in Element can be confusing if you're not used to them. You can access this page which will show you an overview of all rooms in the SeaGL space, allowing you to jump directly into any of them:

<img class="align-center" alt="Screenshot of a screen in Element showing a hierarchical list of all rooms in the SeaGL space" src="/img/element-explore-rooms.webp" />

We recommend you expand the sidebar for quicker access to the main space and subspaces. First, expand the spaces list on the far left (you may have to hover your mouse over the left side to see the arrow):

<img class="align-center" alt="Screenshot of the top-left of the Element client pointing out the arrow directly to the right of the profile picture in the upper-left corner" src="/img/element-sidebar-arrow.webp" />

Then hover over the SeaGL 2024 space—or a relevant subspace—and click the three dots menu, then "Space home":

<img class="align-center" alt="Screenshot of the SeaGL space item in the Element left pane, with the three dots button at the right of the list item highlighted" src="/img/element-three-dots-menu.webp" />


## Widget prompts

SeaGL makes heavy use of Matrix widgets to provide the conference experience. In particular, widgets are how we embed video streams into Matrix rooms—enabling chat participation while watching the talks. Because of this, you may see quite a few permission prompts like this:

<img class="align-center" alt="Screenshot of a widget prompt in Element - a box above the main chat window labeled Welcome to SeaGL 2024 with text that says 'Using this widget may share data with attend.seagl.org' and a button that says 'Continue'" src="/img/element-widget-prompt.webp" />

Please allow these widgets in order to experience the conference properly.


## Call buttons

The audio and video call buttons in Element aren't used in the Matrix rooms where presentations are being streamed—don't click them. If you lose the video stream by accident, here's how to get it back:

1. Click the room info button in the upper-right corner:<img class="align-center" alt='Screenshot of the "i" Room Info button in the top-right corner' src="/img/element-room-info-button.webp" />

2. Under "Widgets", click the pin icon next to "Live Stream" or "Video Conference":<img class="align-center" alt='Screenshot of the "Pin" icon next to a widget item labeled "Live Stream" in the "Widgets" section of the Element Room Info sidebar on the right' src="/img/element-pin-widget.webp" />

<!-- TODO screenshots -->

## Advanced usage: use our Element client

One option that will solve the above caveats is to use our customized version of Element, available at [attend.seagl.org](https://attend.seagl.org). The reason we don't recommend this in the first place is because submitting your Matrix credentials into random websites is bad practice, and we don't want to encourage it. However, we're mentioning this option for completeness and would happily share our service.

If you insist on using our version of Element—hopefully because you really _do_ trust the SeaGL staff with your Matrix credentials, visit [attend.seagl.org](https://attend.seagl.org/) and click "Sign In" under the "Create 2024 Account" button.

To be clear, we have no intention to store, save, or otherwise misuse your credentials—but there are risk that we feel are important to share.
