---
layout: page
redirect_from:
  - /attend-ephemeral
title: Attend SeaGL 2024 Remotely
description: How to attend SeaGL 2024 with an ephemeral Matrix account
---

# Attending SeaGL

SeaGL uses a chat system called [Matrix] for the remote part of our hybrid conference. We've got things set up so Matrix is super easy to use for you - just follow these 3 steps. But if you _do_ run into any trouble, you can email <matrix-help@seagl.org> and we'll help you get it sorted out. <!-- TODO - possibly link to Kiwi IRC too. -->

## Step 1 - get your 2024 account

The first step is to get a 2024 account! This won't require any of your personal information. Come back to this page after you're signed up.

<div class="text-center">
  <p><a class="btn btn-primary btn-large" href="https://attend.seagl.org/#/register?hs=ephemeral">Get my account</a></p>
</div>

This account will be deleted after the conference is over, but for the duration of the conference it will be a full Matrix account and will let you do everything a regular, permanent Matrix account would.

## Step 2 - get oriented

This is the home screen of SeaGL's version of [Element], an open source, free software client that you can use to get onto Matrix. Our Element is slightly modified to give you an even better conference experience.

<img class="align-center" alt="Screenshot of attend.seagl.org" src="/img/attend-portal.webp" />

Some things to know about Matrix and your 2024 account:

1. Matrix is decentralized, which means that your account is “at” the provider of your choice, but you can communicate seamlessly across providers - similar to email.
2. We're acting as the Matrix provider for the account you just made to attend SeaGL. Because your account is primarily intended for you to attend, it will be deleted on **November 17th** (one week after the end of the conference). Before that day, though, it will function as a full Matrix account. (Try joining the Matrix room of a free software project you hear about at the conference!) <!-- TODO it would be rad if we could actually see how many talks are about projects with Matrix rooms -->
3. If you decide you like Matrix, we encourage you to get a permanent account and hang out in the [year-round SeaGL space](https://matrix.to/#/#SeaGL:seattlematrix.org)! There are lots of [options][Matrix options] for using Matrix, but we often recommend [Matrix*.org*][Matrix.org] as a service provider (since it's a public service operated by a non-profit) and [Element] as the client you use to get on Matrix (since it's open source and available on many platforms, including the web).

## Step 3 - have fun at SeaGL!

We hope you enjoy hanging out with our flock this year. Our friendly Matrix bot, Patch, will help guide you around the conference. If you have any questions, please bring them up in the ["Welcome"]( https://attend.seagl.org/#/room/#2024-welcome:seagl.org) or ["Info Booth"]( https://attend.seagl.org/#/room/#2024-info-booth:seagl.org) rooms.

As a reminder, participation in any SeaGL space is subject to our [Code of Conduct](/code_of_conduct).

[Element]: https://element.io/
[Matrix]: https://matrix.org/
[Matrix.org]: https://matrix.org/faq/#who-and-how
[Matrix options]: https://matrix.org/docs/projects/try-matrix-now
