---
layout: page
title: Attend SeaGL 2025
---

<div class="row"><div class="col col-md-10 col-md-offset-1" markdown="1">

# Attend In Person
{:.text-center}

<div class="text-center">
    <p>SeaGL is <b>free to attend</b>, and you <b>do not need to register</b>—just show up!</p>
    <p>You may attend SeaGL without identifying yourself, and you are encouraged to do so to protect your privacy.</p>
    <p>All attendees must abide by the <a href="/code_of_conduct">Code of Conduct</a>, and if participating in-person,
    <a href="/health_and_safety_policy">the Health and Safety Policy</a></p>.
</div>

<div class="row" style="margin-bottom: 1em;margin-top: 2em;">
  <div class="col col-sm-6 col-md-5 col-md-offset-1 col-lg-4 col-lg-offset-2">
    <div class="panel panel-primary text-center">
      <div class="panel-heading"><h2 class="panel-title">Venue Details</h2></div>
      <div class="panel-body">
        <p>SeaGL takes place on the University of Washington campus at the Husky Union Building (known as the HUB).
            This is located on the central campus, west of Stevens Way NE.</p>
        <p>We recommend viewing the indoor map to get familiar with the general layout of the conference.</p>
        <p><a class="btn btn-primary btn-large" href="/maps/2025">View Conference Maps</a></p>
      </div>
    </div>
  </div>
  <div class="col col-sm-6 col-md-5 col-lg-4">
    <div class="panel panel-primary text-center">
      <div class="panel-heading"><h2 class="panel-title">Transportation & Parking</h2></div>
      <!-- HTML/CSS is not my strong suit, apologies if there's a better way-->
      <!-- to margin these to make this the same size as the other row -->
      <div class="panel-body" style="margin-top: 0.7em; margin-bottom: 0.7em;">
        <p>There are several bus routes that take you to the HUB, which can be found on the
            <a href="https://tripplanner.kingcounty.gov/#/app/tripplanning">Metro Trip Planner</a>
            (Search Husky Union Building).</p>
        <p>Parking can be found at the <a href="https://www.washington.edu/maps/#!/padelford-garage-n16-n18-n20-n21">
            Padelford Parking Garage</a>, and is free from 12PM Saturday to 7AM Monday.</p>
        <p><a class="btn btn-primary btn-large" href="https://hub.washington.edu/about/plan-your-visit/#directions">
            More Info</a></p>
      </div>
    </div>
  </div>
</div>

<!-- Added these here to add some space between sections -->
<br><br>

<div id="attend-virtually"></div>
# Attend Remotely
{:.text-center}

<div class="row" style="margin-bottom: 1em;margin-top: 2em;">
  <div class="col col-sm-6 col-md-5 col-md-offset-1 col-lg-4 col-lg-offset-2">
    <div class="panel panel-primary text-center">
      <div class="panel-heading"><h2 class="panel-title">SeaGL 2025 Account</h2></div>
      <div class="panel-body">
        <p>We'll set you up with a Matrix account to attend. Your account will go away when the conference is over.</p>
        <p><a class="btn btn-primary btn-large" href="/attend/ephemeral">Take me to the conference</a></p>
        <p>Pick this if you've never used Matrix before.</p>
      </div>
    </div>
  </div>
  <div class="col col-sm-6 col-md-5 col-lg-4">
    <div class="panel panel-primary text-center">
      <div class="panel-heading"><h2 class="panel-title">Any Matrix Account</h2></div>
      <div class="panel-body">
        <p>We'll give you instructions to get into our Matrix space and help you navigate the conference.</p>
        <p><a class="btn btn-primary btn-large" href="/attend/existing">Join with my Matrix account</a></p>
        <p>Pick this if you already have a Matrix account.</p>
      </div>
    </div>
  </div>
</div>

<div class="text-center">Click <a href="/watch">here</a> to just watch and not participate in chat.</div>

<!-- class="row" -->
</div>
<!-- class="col ..." -->
</div>
