---
layout: post
title: 'SeaGL 2024 Call For Proposals'
status: publish
type: post
published: true
categories: news
tags: '2024'
redirect_from:
  - /cfp
  - /CfP
  - /CFP
nav: cfp
body_id: cfp
---

The awaited time has arrived, the SeaGL 2024 Call-for-Presentations is now open!

### How to submit

Firstly, we've migrated to a new CfP system this year, from OSEM to Pretalx.

Simply go to the [new submission portal](https://pretalx.seagl.org/2024/cfp) and create a new account. Scroll down to the bottom of the page, and click `Submit a proposal`.
Then just follow the steps indicated. You will be able save a draft and come back to it when you are ready to submit.

### What are we looking for

We like to see specific introductions to open-source software, hardware, and tools, as well as technical deep-dives. Outside of technical talks, we welcome talks on FLOSS alternatives to big tech companies' products, hacking for good, personal security and privacy, and open-source in non-tech domains such as education and art.

We’re accepting both 20-minute and 50-minute talks from in-person and virtual presenters. We welcome uncommonly heard perspectives and like to watch presenters get out of their comfort zone to apply lessons across technical disciplines. We also want to see submissions from first-time speakers and members of under-represented groups in tech.

__**We are not looking for sponsored talks**__; but you can take a look at our [Sponsorship Prospectus](https://seagl.org/sponsors/SeaGL_Partnership_Sponsor_Prospectus_2024.pdf) for details on how to reach our attendees in other ways. As a small community event, our attendees tend to be university students, open source hobbyists and engineers, security professionals, technical writers, and more, skewing toward community rather than a corporate feel.

We're looking for talks related to open-source which fall broadly into the ten categories below. We've added examples of past talks for each to give you an idea of what we might be looking for.

If you have a great idea for a talk on open-source which doesn't fit into these categories, then submit it under 'Everything Else'.

 - **Community and Culture**: Open-source hardware and software wouldn't exist without the communities that build and maintain it. This category covers the open-source community and tech communities in general, as well as the cultural aspects of working with technology.
 - **Education**: This category covers both the use of open-source software in education and technical education in general, from elementary school to university.
 - **Hardware**: This category is for adventures in open-source hardware, whether it be about building your own or developing on top of projects created by others.
 - **Languages and Tools**: This category is all about the languages and tools that we use in our day-to-day work. It covers everything from shell scripting to open-source languages such as Rust and Python, as well as tools built for the open-source ecosystem.
 - **Machine Learning and Big Data**: Data isn't just the domain of large tech companies. From open-source tools for machine learning to data management strategies, this category covers everything related to machine learning and big data.
 - **Open Source Careers**: If you want to talk about building a career in open-source technology, or leveraging your experience with FLOSS communities in a work context, you've come to the right place. We welcome discussions on how FLOSS can benefit everyone from a career point of view.
 - **Performance Art**: This category encompasses both performance art about the tech community, and art projects which are supported by open-source software. From stand-up comedy to generative art to knitting with software, we would love to see what you can come up with!
 - **Security and Privacy**: Open-source communities have been at the forefront of security and privacy for many years. As well as securing your tech stack, talks in this category will look at the human side of security, and the privacy impacts of today's tech ecosystem.
 - **Systems and Platforms**: How does old-school systems administration fit into the IT industry of today? What do we need to do to run platform teams using open-source software? This category covers everything related to the systems and platforms on which we build, from systems architecture to DevOps to CI/CD.
 - **Everything Else**: Have a great talk that doesn't fit these categories? Submit it here!

### What we expect from speakers

The SeaGL [Code of Conduct](/code_of_conduct) and [Health & Safety Policy](/health_and_safety_policy) applies to staff, presenters, volunteers, attendees, and sponsors alike. The content of your presentation, and your behaviour at the conference, must abide by both the Code of Conduct and Health & Safety Policy.

To present at SeaGL, you'll need to be able to do one of the following:

* be in Seattle on **November 8th or 9th** to present live;
* or, be available to present via live-streaming on **November 8th and 9th**, with a required technical check a week before.

### Office Hours

SeaGL pioneered the idea of CfP Office Hours, so stay tuned for details. If you need help in the meantime, please email us at {{ site.custom.a.email.cfp-help }}, or join [the General Discussion room](https://matrix.to/#/#general:seagl.org) in SeaGL's Matrix space.

### Deadline

You can enter proposals until ~~2024-06-30 23:59 (UTC)~~ Extended until **2024-08-05 23:59 (UTC)** ~~2024-07-14 23:59 (UTC)~~. 

### About expenses

SeaGL is an annual community-focused Free/Libre/Open-Source event in Seattle. Since 2020, we also broadcast all over the world virtually! We're an independent bunch, but we still like to take care of each other. However, as a grassroots community conference, we are not able to pay travel or lodging expenses for speakers.
