---
layout: post
title: 'SeaGL 2023 Call For Proposals: What we want'
status: publish
type: post
published: true
categories: news
tags: '2023'
---

If you're thinking of submitting to SeaGL 2023, you've come to the right place to learn more!  For details on how to submit, go [here](/news/2023/03/08/CFP-Open).

### Talk Categories

We're looking for talks related to open-source which fall broadly into the ten categories below.  We've added examples of past talks for each to give you an idea of what we might be looking for.

If you have a great idea for a talk on open-source which doesn't fit into these categories, then submit it under 'Everything Else'.

- **Community and Culture**: Open-source hardware and software wouldn't exist without the communities that build and maintain it.  This category covers the open-source community and tech communities in general, as well as the cultural aspects of working with technology.
  * [Walking the Cultural Tightrope](https://archive.org/details/SeaGL2021-Aeva_Black-Walking_The_Cultural_Tightrope), by Aeva Black at SeaGL 2021
  * [Alcohol and Inclusivity in Tech](https://archive.org/details/SeaGL2020-Kara_Sowles-Alcohol_and_Inclusivity_in_Tech), by Kara Sowles at SeaGL 2020
  * [Move Slow and Try Not to Break Each Other](https://archive.org/details/SeaGL2020-Deb_Nicholson-Move_Slow_and_Try_Not_to_Break_Each_Other), by Deb Nicholson at SeaGL 2020
- **Education**: This category covers both the use of open-source software in education and technical education in general, from elementary school to university.
  * [The Leaky Pipeline](https://archive.org/details/SeaGL2022-Aarti_Ramkrishna-The_Leaky_Pipeline), by Aarti Ramkrishna at SeaGL 2022
  * [Stories from reviving and extending a university's information security program](https://archive.org/details/SeaGL2021-Brian_Callahan-Reviving_and_extending_a_universitys_infosec_program), by Brian Callahan at SeaGL 2021
  * [Rise up for free software in schools!](https://archive.org/details/SeaGL2020-Mariah_Villarreal-Rise_up_for_free_software_in_schools), by Mariah Villareal at SeaGL 2020
- **Hardware**: This category is for adventures in open-source hardware, whether it be about building your own or developing on top of projects created by others.
  * [Building Your Own Keyboard with Free Software](https://archive.org/details/keeb_20200110), by Brian Mock at SeaGL 2019
  * [Automatic Chicken Door HOWTO](https://archive.org/details/AutomaticChickenDoorHOWTOATalkByAdamMonsenAtSeaGL2017), by Adam Monsen at SeaGL 2017
- **Languages and Tools**: This category is all about the languages and tools that we use in our day-to-day work.  It covers everything from shell scripting to open-source languages such as Rust and Python, as well as tools built for the open-source ecosystem.
  * [Intro to jq: grep for JSON](https://archive.org/details/SeaGL2021-der_hans-Intro_to_jq_grep_for_JSON), by der.hans at SeaGL 2021
  * [Good Shell Patterns](https://archive.org/details/SeaGL2021-Bri_Hatch-Good_Shell_Patterns), by Bri Hatch at SeaGL 2021
  * [Let's Make Games With Rust](https://archive.org/details/SeaGL2020-Elijah_C_Voigt-Lets_Make_Games_with_Rust), by Elijah C. Voigt at SeaGL 2020
- **Machine Learning and Big Data**: Data isn't just the domain of large tech companies.  From open-source tools for machine learning to data management strategies, this category covers everything related to machine learning and big data.
  * [Accessible Data Visualization](https://archive.org/details/SeaGL2022-Bradley_Molinaro-Accessible_Data_Visualization), by Bradley Sabin Molinaro at SeaGL 2022
  * [First steps with Swift for TensorFlow](https://archive.org/details/SeaGL2020-Paris_Buttfield_Addison_and_Tim_Nugent-First_steps_with_Swift_for_TensorFlow), by Paris Buttfield-Addison and Tim Nugent at SeaGL 2020
  * [Learning Natural Language Processing through The Regender Project](https://archive.org/details/regender), by Eva Monsen at SeaGL 2019
- **Open Source Careers**: If you want to talk about building a career in open-source technology, or leveraging your experience with FLOSS communities in a work context, you've come to the right place.  We welcome discussions on how FLOSS can benefit everyone from a career point of view.
  * [Finding the right tools for your new job](https://archive.org/details/SeaGL2022-Dawn_E_Collett-Finding_the_right_tools_for_your_new_job), by Dawn Cooper at SeaGL 2022
  * [Know Your Rights as a Tech Worker](https://archive.org/details/SeaGL2021-Shauna_Gordon-McKeon-Know_Your_Rights_as_a_Tech_Worker), by Shauna Gordon-McKeon at SeaGL 2021
- **Performance Art**: This category encompasses both performance art about the tech community, and art projects which are supported by open-source software.  From stand-up comedy to generative art to knitting with software, we would love to see what you can come up with!
  * [Stand-up comedy about FLOSS](https://archive.org/details/SeaGL2020-Sumana_Harihareswara-Stand_up_comedy_about_FLOSS), by Sumana Harihareswara at SeaGL 2020
- **Security and Privacy**: Open-source communities have been at the forefront of security and privacy for many years.  As well as securing your tech stack, talks in this category will look at the human side of security, and the privacy impacts of today's tech ecosystem.
  * [What's Anonymity Worth?](https://archive.org/details/SeaGL2022-Kaylea_Champion-Whats_Anonymity_Worth), by Kaylea Champion at SeaGL 2022
  * [Computing Confidentially in the Clouds](https://archive.org/details/SeaGL2021-Aeva_Black-Computing_Confidentially_in_the_Clouds), by Aeva Black at SeaGL 2021
  * [Open Source Secrets Management](https://archive.org/details/SeaGL2020-Gareth_J_Greenaway-Open_Source_Secrets_Management), by Gareth J. Greenway at SeaGL 2020
- **Systems and Platforms**: How does old-school systems administration fit into the IT industry of today?  What do we need to do to run platform teams using open-source software?  This category covers everything related to the systems and platforms on which we build, from systems architecture to DevOps to CI/CD.
  * [Building cloud networks: Terraform or Ansible?](https://archive.org/details/SeaGL2021-Francois_Caen-Building_cloud_networks_Terraform_or_Ansible), by François Caen and Troy Perkins at SeaGL 2021
  * [Building Free CI/CD with GitHub Actions](https://archive.org/details/SeaGL2020-Cameron_Bielstein-Building_Free_CI_CD_with_GitHub_Actions), by Cameron Bielstein at SeaGL 2020
  * [Microservices: A Cautionary Tale](https://archive.org/details/microservices_202001), by Amulya Bandikatla at SeaGL 2019
- **Everything Else**: Have a great talk that doesn't fit these categories?  Submit it here!
  * [The internet is unusable: the disabled view](https://archive.org/details/SeaGL2022-Nicolas_Steenhout-The_internet_is_unusable_The_disabled_view), by Nicolas Steenhout at SeaGL 2022
  * [Patently Obvious](https://archive.org/details/SeaGL2020-Neil_McGovern-Patently_Obvious), by Neil McGovern at SeaGL 2020

### What we are and aren't looking for

SeaGL is a community-focused Free/Libre/Open-Source annual event in Seattle.  Since 2020, we also broadcast all over the world virtually!  We're an independent bunch, but we still like to take care of each other.

We like to see specific introductions to open-source software, hardware, and tools, as well as technical deep-dives.  Outside of technical talks, we welcome talks on FLOSS alternatives to big tech companies' products, hacking for good, personal security and privacy, and open-source in non-tech domains such as education and art.

We are not looking for sponsored talks; you can take a look at our [Sponsorship Prospectus](/sponsors/) for details on how to reach our attendees in other ways.  As a small community event, our attendees tend to be university students, open source hobbyists and engineers, security professionals, technical writers, and more, skewing toward community rather than a corporate feel.
