---
layout: post
title: 'SeaGL 2021 Call For Proposals'
status: publish
type: post
published: true
categories: news
tags: '2021'
---

Welcome to the 2021 SeaGL Call For Proposals!  Every year, we want to hear from YOU, and we're always looking for speakers who are traditionally underrepresented in tech, and people with perspectives uncommonly heard, as well as first-time speakers.  Because we're virtual for the second year in a row, there is opportunity for speakers anywhere in the world to submit talks!  In 2020, we had talks from four continents!!  So let's take advantage of our virtual closeness for another year.

### Details
CfP Open: Thursday 24 June 2021

CfP Close: ~~Thursday 5 August 2021~~Thursday 19 August 2021

Acceptances: Early September 2021

Finalized Speakers: Mid September 2021

Program Published: Late September 2021

CONFERENCE: Friday 5 November and Saturday 6 November 2021!

Submit at: [OSEM][submit]

### Committee and Code of Practice
The Program Committee is the group responsible for choosing and scheduling all of the great talks you enjoy at SeaGL. This year the committee steering the Program consists of:

* Nathan Handler (co-chair)
* Rachel Kelly (co-chair)
* Monica Ayhens-Madon
* Remy DeCausemaker
* Megan Guiney
* Sri Ramkrishna
* Alison Yu

As in prior years, we agree to abide by the [SeaGL Program Committee Code of Practice](/code_of_practice).

### Code of Conduct
The [SeaGL Code of Conduct](/code_of_conduct) applies to all staff, all volunteers, all speakers and keynotes, all attendees and viewers, and all sponsors.  **SeaGL is dedicated to providing a harassment-free conference experience for everyone; regardless of gender, gender identity and expression, sexual orientation, disability, physical appearance, body size, nationality, race, or religion.**  We do not tolerate harassment of conference staff, volunteers, presenters, attendees, and participants in any form.  Conference participants violating these rules may be sanctioned or expelled from the conference, without a refund, at the discretion of the conference organizers.

These are more than words, they are a framework that we have used and will use in the future when the situation calls for it.  We encourage you to become familiar with the contents of the [SeaGL Code of Conduct](/code_of_conduct), as you indicate your strong agreement to these principles in submitting a talk, attending the conference, volunteering, sponsoring, or otherwise participating in the conference.

### Talk Topics/Labels
We encourage almost any topic related to open source that you have a personal engagement with. We have created a list of topic labels you might choose to use — these might give you some ideas.

- Security: Security Practices (Personal and Industry) and Security Career
- Hardware: Free and Open hardware projects
- Leaving the Walled Garden: Owning Your Own Data
- Tools: Command line, databases, web tools, accessibility, open graphics tooling, and more
- Tech Culture: FLOSS for EveryOne: how can FLOSS be of help to those outside our immediate community?
- Community: Community building, labor rights, & advocacy
- Virtual meetings & "meatspace"
- DevOps: Open source DevOps, containers, continuous integration/continuous deployment, & monitoring
- Licensing & Legal
- Career Development in FLOSS software and hardware
- Performance Art!  Seriously :)
- Misc: Have a great talk that doesn't fit these categories? Submit it!

### Talk categories and "vibe"
SeaGL is a very special conference.  We're a community-focused Free/Libre Open Source Software annual event in Seattle, and since last year, all over the world virtually!  We're looking for technical talks from folks who usually give community talks, and activism talks from folks who usually give coding deep dives, and so forth. We would love to see you out of your comfort zone.  The categories we used last year were, loosely: Security, Community, Career Development, Tech Culture, Tools, Virtual Life & Work, DevOps, Performance Art! and Miscellaneous, and we had amazing submissions as a result, like Devops Standup and several talks on labor organizing!  We're an independent bunch but we still like to take care of each other.

We are not looking for sponsored talks, however we'd love to welcome you over at our [Sponsorship Prospectus](/sponsors/2021) and give you an opportunity to reach our attendees in other ways.  As a small community event, our attendees tend to be university students, open source hobbyists and engineers, security professionals, technical writers, and more, skewing toward community rather than a corporate feel.

We're not very likely to accept broad introductory talks, but specific, scoped introductions to a discrete part of the Operations or Network/Sysadmin world are very sought after, and we also love talks on the broad theme of "hacking for good", and personal security as well.  Are you making choices for your personal technology outside of Amazon/Google/Apple/other giants?  We would love to hear about that too!

We welcome talks you have given elsewhere, but if you have, please indicate so in the abstract (a link would be great) and let us know how this talk will be different.

### Talk structure
Talks will be presented remotely. Speakers may give their session live, or pre-record their session for the room moderator to play while they are in the chat session with the attendees.

Talk length is 20 minutes, with another 10 minutes allowed for questions, for 30m total.

We do not have longer time slots available at SeaGL 2021 because the online medium makes it more critical to present yourself concisely. Please do not propose talks that cannot be presented well within the allotted time. If you have a topic that absolutely needs more time, consider breaking your proposal into two talks: an introductory talk and a more "advanced" talk.

### Office Hours
SeaGL pioneered the idea of CfP Office Hours, so stay tuned for details, and if you need help in the meantime, please email us at {{ site.custom.a.email.cfp-help }}, and we'd love to help you work through a good proposal.

### How To Submit
FINALLY, let's talk about how to submit!  First, you'll go to SeaGL's [OSEM][submit] and either create an account or log in to an account you have previously used.  For those of you who have submitted before, this is the same system as the last several years.

Scroll down to the Call For Papers section, and "Submit your paper now" for your proposal, and then New Proposal.  There you'll input the Title, Talk Type (there is only one - 20m talk), and the Abstract, up to 500 words.  Do not put your name or biography in your proposal.  Repeated, **do not put your name or your bio in your proposal**.  It is part of our [Code of Practice](/code_of_practice) that our initial review is unaware of who the submitter is, therefore **any proposal which includes biographical information will be rejected**.  Your bio will be asked for later.

When you have submitted, you will be taken to a page called Proposals for SeaGL 2021, and you will see your own talk(s) listed there.  This is where you will add your bio and the talk label ("track").  Please note, you will not receive an email confirming your proposed submission.

Finally, please find the plaintext link to our submission software here: https://osem.seagl.org/conferences/seagl2021

### Thank you!
Thank you!!  Please email us or [tweet](https://twitter.com/seagl) at us with any questions!  And don't forget to [Submit Early, Submit Often][submit]!


[submit]: https://osem.seagl.org/conferences/seagl2021#callforpapers
