---
layout: post
title: 'Meet our Keynoters: Máirín Duffy'
status: publish
type: post
published: true
categories: news
tags: '2020'
image: /img/posts/2020_Keynote_Duffy.jpg
---

![Máirín Duffy](/img/posts/2020_Keynote_Duffy.jpg){:.align-left}

Continuing our [Meet our Keynoters blog series](/news/2020/09/08/vmbrasseur-keynote-interview), it is our pleasure to announce our next keynoter, **Máirín Duffy**.

Máirín is a senior principal interaction designer at Red Hat as well as the team lead for Fedora’s community design team. A recipient of the 2016 O’Reilly Open Source Award, Máirín has over a decade of expertise in user experience and design in Free/Libre and Open Source Software (FLOSS) communities. Her portfolio includes a wide range of designs for FLOSS including the ChRIS project, Mailman/Hyperkitty, Anaconda, numerous components of the Fedora project infrastructure, Spacewalk, virt-manager, the GNOME desktop, as well as other projects such as the
SELinux and Container Coloring Books.

> You are the artist behind the [SELinux Coloring Book](https://people.redhat.com/duffy/selinux/selinux-coloring-book_A4-Stapled.pdf). Was that as fun to make as it sounds like? Can we expect more coloring books in the future?

Yes, that was an *extremely* fun project! I've worked with Dan Walsh on a number of these so far - The SELinux Coloring Book, The Containers Coloring Book, and the Container Commandos Coloring Book. Dan is a really brilliant engineer and the whole idea was his - he had been using the dogs & cats analogy in his SELinux talks for some time, and wanted some illustrations for an adaptation he was writing for an opensource.com article. He came to me for help, and as the illustrations came along he had the idea to package it up as a coloring book. It's been an awesome collaboration with him and the books are still quite popular as hand outs (now as virtual PDF handouts, but all the same otherwise!)

I also wrote the script for and mentored a couple of interns on an Ansible coloring book, and the final version of that should be coming out in the next couple of months or so. Finally, my intern from this past summer Madeline has been working on another new one that should be coming out in the next couple of months or so, Event-Driven-Architecture (EDA) and the Three Dwarves. Her illustration skills are really next-level, so I'm anticipating that one will be a big hit! You can follow the progress on that in the [GitHub repo](https://github.com/fedoradesign/coloringbook-eda).

We also may have another one coming down the line around container security. No solid plans yet, but attaching a teaser. :)

> As a UX Designer at Red Hat you've been part of improving the FOSS user experience over many years. What's the biggest positive change you've seen in FOSS UX recently?

I think the biggest positive change in FOSS user experience recently is just the number of practitioners who are out there, working with open source projects. I think it's fantastic to see - I also think it's part of open source generally being the new default way to go in software. We have more projects starting up as open source, and UX as a practice is more and more recognized as important in the software development community, so those projects as a matter of course are bringing designers on board.

What I would like to see more of is designers working even further into upstream project leadership and getting a seat at the table at that level. I think we are on track to get there, and it'll further accelerate the improvement of the FOSS user experience.

> How and when did you get involved in FOSS? What attracted you?

I was raised in a technologically savvy family well before that was really a thing in the 1980s and 1990s; I remember playing Smurfs Paint 'n Play on a Coleco ADAM while a preschooler and imagining someday I'd be a computer artist for video games!

When I was in high school, my brother commuted to the state university and studied computer science. At the time, our house only had one phone line, and I was a teenager so that phone line was tied up. A lot. This was often an impediment to my brother's ability to telnet into his school to compile his homework. He came home with a copy of Red Hat Linux one day and installed it on the family computer so he could use gcc. I loved playing with the desktop, redesigning it and customizing it to my liking - because it was open source, there was a much greater ability to do cool things with it than you had with Microsoft Windows 98 which was the dominant desktop of the time. These were pre-GNOME days, and the aesthetics and generally usability left a lot to be desired. I wanted to help make it better and thought with my own creative background that I had skills that would be worthwhile to contribute.

While I didn't fully understand or was even aware of the GNU Manifesto or The Cathedral and the Bazaar at the time, I did understand that Microsoft's monopoly on desktop computing was a widespread problem and it would be better to have usable alternatives. The general concept around free software being an essential freedom for users was a lesson I learned early on in my college career, when I became a whiz with a creative tool called Macromedia Director. I used it for projects my freshman year of college that by my senior year had completely bitrotted due to Macromedia changing focus to Flash and then getting bought out by Adobe. That these extremely expensive tools, both in the cost of the software and the cost of the training to use them, would fall over with no recourse for all of those users who'd bought into it really convinced me of the importance of software freedom for users.

Due to the economic downturn (dotcom bust and September 11th) before I graduated with my computer science degree, there were no jobs to be had. I ended up staying on for grad school and studied Human-Computer Interaction. I used and loved Linux throughout my career in school (going so far as to doggedly use OpenOffice Calc for my physics projects that had been written for Excel), and was definitely thinking that I could apply HCI principles to open source software to further improve it. I ended up doing an internship with Red Hat's desktop team in the summer during my graduate program and that experience really got me on the right track to become a contributor. I met people face to face rather than over IRC and mailing lists, and the Red Hat folks were wonderful mentors in helping me get involved in upstream projects. I came back to work as a full-time Red Hatter after graduation - if it was open source and needed design, I was happy to work on it, so I've always had tons of brilliant opportunities at Red Hat!

> What FOSS thing are you currently involved with that you think is great, but that people might not be aware of?

I think the ChRIS project definitely fits this description. ChRIS is a fantastic open source project that is working towards improving healthcare and enabling medical researchers to use many of the amazing (and open source!) medical image processing tools that exist to further advance medicine. I think ChRIS as a project also really illustrates well the point that having the open source technology isn't enough - it has to be usable, and it has to provide a reasonable user experience to really make an impact. You will learn much more about this project at my keynote. :)

> What is something interesting about you that most people might not be aware of?

Tá Gaeilge beagan agam agus ba mhaith liom aon duine a labhairt liom faoi Open Source nó Linux nó UX i nGaeilge am ar bith! I'm an intermediate-level Irish learner (I write my first name in Irish) and I'd love to talk with anybody about open source or Linux or UX in Irish anytime :)

Another tidbit - I only use FOSS to create my designs, all these years. My main tools are Inkscape, Gimp, Krita, KdenLive on a Fedora Linux desktop. I haven't used any of the Adobe tools in almost 15 years!

> Is there anything else you want to share?

I'm really looking forward to SeaGL!
