---
layout: post
title: 'Why SeaGL?'
status: publish
type: post
published: true
categories: news
tags: '2020'
---
_by VM (Vicky) Brasseur_

There was one final question in the [keynote interview](/news/2020/09/08/vmbrasseur-keynote-interview) that the team sent me:

> As a long-time contributor to the SeaGL ecosystem (thank you!), how do you view SeaGL in relation to the many other fine FOSS conferences and events you participate in? What strengths of SeaGL keep you coming back?

This question, "Why SeaGL?", is important enough that it deserves its own post. _(Full disclosure: while I haven't had the time to do so the past couple of years, in the past I was a member of the SeaGL organising committee.)_

I've [spoken at](http://vmbrasseur.com/presentations/) and attended FOSS events of all sorts and feel qualified to say that **SeaGL is special**. Of all the events out there, SeaGL is the only one I've found with a singular focus on bringing FOSS to more people, and bringing more people to FOSS. While other events do a good job of this, SeaGL may be the most welcoming conference I know.

There are a lot of free and open source software (FOSS) events in the world. Some of them are dedicated to supporting and bringing together specific communities, like [Fedora Flock](https://flocktofedora.org) or [GUADEC](https://events.gnome.org/e/guadec2020). Others, like [All Things Open](https://www.allthingsopen.org) or [FOSDEM](http://fosdem.org) are more general and are there to support and provide training on many FOSS projects. Then there are the corporate events like [Open Source Summit](https://events.linuxfoundation.org/open-source-summit-north-america/) that bring together business interests and help them learn how to integrate FOSS into their companies more successfully.

SeaGL is now and always has been [free-as-in-beer](https://en.wiktionary.org/wiki/free_as_in_beer) to attend. If you can get to the event—which is [easier than ever](/news/2020/05/05/virtualconf-2020)—you can learn from and speak with some of the brightest minds in the FOSS world and it won't cost you a cent. This is by design. Having the money to attend a conference prevents many from participating in FOSS and diminishes the entire movement. SeaGL has removed the financial burden and is able to welcome everyone to learn about free and open technologies and communities. It's able to do this thanks to the [generous support of its sponsors](/sponsors/SeaGL_Exhibitor_Sponsor_Prospectus_2020.pdf).

In normal times, SeaGL takes place over two days at [Seattle Central College](https://seattlecentral.edu). SeaGL schedules the event so at least one of the days occurs during classes, then flings open the doors and welcomes curious students who otherwise wouldn't have the opportunity to learn about FOSS, let alone attend a tech conference. To ensure even more people are able to attend, SeaGL has provided childcare so attendees don't have to choose between taking care of their family or getting the FOSS training that can help them in their careers.

Of all the events I've seen, SeaGL is the most dedicated to supporting and bringing new conference speakers to the FOSS world. Most events aim to bring in and promote big name speakers to help attract attendees. SeaGL prefers to recruit and mentor new speakers, believing that everyone has something of value to share in FOSS. The program committee operates according to a [code of practice](/news/2020/07/13/code_of_practice) and is prepared to provide any and all assistance to help bring new voices to the free software movement. Half of the keynote slots are reserved for people who have never stood on a keynote stage before, spotlighting the unsung heroes of FOSS.<!--Not mentioning the awards here since I'm not sure whether they're happening this year.-->

People of all genders, races, colours, and religions (operating system and otherwise) are safe at SeaGL. Want to present a talk about a free software tool you built on Windows? You're welcome here! How you coordinated a [Pride Week](https://en.wikipedia.org/wiki/Gay_pride) event using FOSS? Splendid! We want to hear it! A case study on how optimising your free software project for [accessibility](https://en.wikipedia.org/wiki/Web_accessibility) increased usage across all vectors? Fascinating! Tell us more!

However much the media declares that "FOSS has won," SeaGL recognises that until everyone is able to enjoy [the Four Freedoms](https://en.wikipedia.org/wiki/Free_software#Definition_and_the_Four_Essential_Freedoms_of_Free_Software), the free software movement will still have a lot of work to do. It does its part by being a welcoming and inclusive event. The one thing that is not welcome at SeaGL is hatred. SeaGL believes in and enforces its [Code of Conduct](/code_of_conduct) to ensure that all speakers and attendees will not be harassed or made to feel unwelcome or unsafe.

Underlying it all is SeaGL's fundamental belief that _Free Software is for Everyone._ Many conferences will do some of these things, but I've seen no other conference that does them all, let alone as well. SeaGL isn't doing this for itself. It's not trying to be the biggest or most buzz-worthy event. It's doing the wood chopping and water carrying needed to help build and support the next generation of FOSS advocates, and that's a pretty powerful thing.
