---
layout: post
title: 'Meet our Keynoters: VM (Vicky) Brasseur'
status: publish
type: post
published: true
categories: news
tags: '2020'
---

SeaGL 2020 is less than two months away. We are thrilled to be able to start revealing our lineup of awesome keynote presenters and to give you the opportunity to get to know all about their amazing achievements through a series of interviews. Our first keynoter is **VM (Vicky) Brasseur**.

[VM (Vicky) Brasseur](https://vmbrasseur.com/) is an award-winning free/open source advocate and corporate strategist, international keynote speaker, and writer. She’s the author of [Forge Your Future with Open Source](https://fossforge.com/), the only book detailing how to contribute to free/open source (FOSS) projects. Aside from articles in [various publications](https://www.vmbrasseur.com/publications-interviews/), she also writes about FOSS, business, and their intersection on [her blog](https://anonymoushash.vmbrasseur.com/).

> You've literally written the book on Open Source!  What did you learn in this process, and can we look forward to more books from you on the horizon?  What lessons do you hope people walk away with after reading it?

Writing a book is no small feat and I won't diminish that, but the content itself comprises generations of knowledge and best practices. A lot of the credit for [the book](https://fossforge.com) should go to those who came before me and developed those practices through trial, error, and a lot of work. The community did the hard work. All I did was write it down.

I've learned that the process of writing the book takes a lot longer than you'd expect.  Scope creep: it's not just for software. You need to keep your work focused. Also similar to software, it's important to have someone else review your work. The book is so much better because of the feedback from the technical reviewers. I'm so grateful to them for all of their insights, and especially to my friend and editor Brian MacDonald for helping to keep me on task and on topic.

There are two things I'd like people to take away from the book, one each for different audiences. For contributors—potential or otherwise—I want you to recognise that you _can_ contribute, you _do_ belong in FOSS, that FOSS needs you whatever your skillset, and that you can and should take the time to ensure that your efforts help _you_ as much as they help FOSS. The book helps with these things so you have a better chance of being successful with your contributions and overall FOSS experience.

Secondly, for maintainers—who can learn a lot from the book, too—I want you to rediscover the newbie mindset. Many maintainers have been doing FOSS for a long time and have lost the perspective of someone new to our world. Reading the book can help to regain some of that so you can identify ways to make your project more welcoming and easier to use and contribute to, opening the door to better sustainability for your project and the entire ecosystem.

As for whether there are other books on the horizon… I have some ideas that I'm tossing around but if I say something publicly people will hold me to it and I'm ready for that sort of commitment quite yet.

> From something you said in a recent blog post, it seems like one of your interests is extending the idea of open projects beyond coding and into other areas. How have you seen this progressing over time? What do you think the future of this idea is?

There are signs that the ethos of open is spreading to other areas. You have [open seeds](https://osseeds.org) for instance, a movement for collecting and sharing crop seeds that are unencumbered by patents; and [open access](https://en.wikipedia.org/wiki/Open_access), where libraries and research institutions are ensuring access to research. I could probably fill a book with case studies of how openness is being embraced across the world (but I won't 😉).

We need to remember is that needing to open up things like research, seeds, and source code is a relatively new concept. Access to research used to be free and open…if you were a rich, white man. Previously it was common practice to set aside a portion of a harvest as seeds for the next year, and to trade seeds with other farmers. At the dawn of software source code, as most of us probably know, used to be shared freely between computer operators and even manufacturers. It's only recently that all of these things have become more difficult to share.

While I'm not going to put on my rose-coloured glasses and stamp my little princess foot to demand a return to those halcyon days of (mythical) sharing perfection, I do think that we should reevaluate the default use and distribution models common today. Upon reflection, we may find that many of them are based more on fear or greed than anything else, and that there may be a better way to approach them.

Unfortunately I'm not optimistic that this will happen any time soon. There are some inspiring examples—like libraries [throwing off the shackles](https://science.sciencemag.org/content/363/6431/1023.1) of ridiculously expensive journal access or TOR publishing [going DRM-free for their books](https://www.tor.com/2012/07/20/torforge-e-books-are-now-drm-free/)—but overall we're seeing more resources locked behind paywalls and restrictive EULAs, not less. The reopening of our resources will take a lot of attention and diligence, and if it happens at all it will be piecemeal. One farmer choosing open seeds. One university choosing open access. One publisher choosing DRM-free. Each one is a baby step, but those are still steps and move us all toward a more open and sustainable future.

> How and when did you get involved in FOSS? What attracted you?

Like many of us who went to university in the 1990s, I spent a great deal of time in the computer lab. While I mostly played on various MUDs/MUSHes/MUCKs/BBSs (as one did in those days), I also toodled around Usenet, Archie, and Gopher. It was on Gopher where my friends and I discovered [Project Gutenberg](http://gutenberg.org). Documents and books? Just out there for free? Because…sharing is good and helps everyone? While the lab attendant was busy scolding me for blocking the dot matrix printer by printing out [Alice in Wonderland](https://www.gutenberg.org/ebooks/11), I was busy falling down my own rabbit hole of free culture. This naturally led to discovering Free Software by way of Usenet and the rest is history.

At the time I was a science major, so the idea of freely sharing and distributing research felt natural. What hadn't occurred to me before that moment was that this sharing, if applied to other areas, could benefit even more people than ever before. Scientists stood on the shoulders of those who came before them, so why shouldn't others? The power of sharing work to enable and lift up others became a fundamental part of my belief system from there on out. Unfortunately I think we in FOSS often lose sight of that part of the mission: using software to empower and lift up people who otherwise might not have the opportunity.

> What FOSS thing are you currently involved with that you think is great, but that people might not be aware of?

It's not ready to launch quite yet, but I've been working on a catalog of governance documents from all over the FOSS world. This sounds like a sleep-inducing project for most people reading this, I realise, but it has the potential to make it a lot easier to establish governance in a FOSS project or even to research various governance models and elements. Trust me, the umpteenth time you need to find examples of privacy or voting or trademark policies as you launch or scale up a FOSS project (as I have), you'll wish that this resource already existed. I used to make the most progress on the catalog during long plane flights, but since the pandemic started and travel stopped I've had to fit it in between my other tasks. It's getting really close to launch, but as we all know that last 20% of any project somehow ends up taking 80% of the time.

> What is something interesting about you that most people might not be aware of?

One of my bachelor's degrees is in Latin, but that's mostly because my uni didn't offer a degree in Ancient Greek. I have four years of university-level training in Latin but five and a half in Ancient Greek. Had that job offer in tech not landed in my lap in the late 90s, I'd have headed to grad school for Classics instead, eventually becoming a [papyrologist](https://en.wikipedia.org/wiki/Papyrology).

Of those two languages, Latin is the one that still gets the most direct workout, mostly from people asking me to translate phrases from English so they can put them on a patch, seal, or tattoo to look more impressive. The Greek training, however, is used every single day of my life. The teachings of that professor rewrote how my brain works and I've never looked at the world the same again. Thank you, Carl. I think about you all the time. You're wonderful and have changed my life for the better.
