---
layout: post
title: 'Not sure about a topic? We can help!'
status: publish
type: post
published: true
categories: news
tags: '2020'
---

With the [Call For Proposals extended](/news/2020/08/20/cfp-extension), we thought we'd take a moment to brainstorm a few topics that we'd love to see proposed for the event, but so far haven't seen a large response in the CFP.

### Hardware

If you look in the section "About" SeaGL, you'll see right there that free / libre / open *hardware* is mentioned as one of the things we're seeking to raise awareness and knowledge about. This can range from [RISC-V](https://riscv.org/) and [OpenPOWER](https://openpowerfoundation.org/) to the [Raspberry Pi](https://www.raspberrypi.org/), which has open components and is used by many open source projects. Open hardware talks always do well at SeaGL and offer a change of pace from what is otherwise a conference largely focused on software, so we'd love to see them!

### Privacy and social good

With 2020 bringing a lot of change to our lives, and SeaGL's commitment to social good [and causes like Black Lives Matter](/news/2020/06/12/black-lives-matter), many SeaGL attendees are curious about where privacy fits into open technology.

Whether you know something about open data sets, the intersection of privacy and protesting, or how we can stay safe when we enable contact tracing for COVID-19 on our devices, these are topics that have touched all of our lives this year. We're looking forward to to hearing your expertise.

### Software foundations

Are you involved with a software foundation? Or have you had a recent experience with them that you'd like to share? Whether you are working on a project within a foundation, or have first hand experience with the inner workings of one, a lot of projects have started moving to this model and there's a lot of curiosity around the benefits and trade-offs of having your project supported and promoted by one.

### Performance Art

Heck yeah, that's right, we want art at this year's SeaGL!  If it can fit into 30m, let's see it :) Beat poetry about voter rights? Mathematically generated art? A video game you can stream in less than ~20m? If what you have in mind is reasonably Safe-For-Work, let's talk! If you have any questions about this, please reach out and we'd LOVE to help, at <cfp-help@seagl.org>.

* "Reasonably safe for work" for SeaGL includes talking about LGBTQ topics, labor rights, and as always, computer/device hacking!  We take a pretty critically broad view of what is safe, because what keeps marginalized members of our community safe is what keeps us all safe.

### Have *too many* ideas?

We have good news, you can submit multiple proposals! But if you're an experienced speaker, we also encourage you to reach out to others in your network who may have expertise with one of your ideas. We love seeing a mix of new and experienced speakers at SeaGL, and encouragement from a seasoned speaker like yourself can go a long way to support the next generation.

### Still not sure?

Feel free to refer back to our [initial CFP](/news/2020/07/14/CFP-open) for a long list of talk topic suggestions. We will also be continuing to offer CFP Office Hours every Wednesday at noon PDT in #seagl on irc.freenode.net. You can also email <cfp-help@seagl.org> at any time for help/guidance with your proposal. We are here to help.
