---
layout: post
title: 'Call For Speaker Proposals: SeaGL 2020'
status: publish
type: post
published: true
categories: news
tags: '2020'
---

**UPDATE** - The CFP deadline was extended to Wednesday, September 9th. See [CFP extension](/news/2020/08/20/cfp-extension) for complete info. Speaker notifications will go out by the end of September, with the schedule published shortly after. - **UPDATE**

We are more than excited to invite you to speak at SeaGL 2020! The Seattle GNU/Linux Conference (SeaGL) is a grassroots technical conference dedicated to spreading awareness and knowledge about the GNU/Linux community and free / libre / open source software and hardware. This year it will be held remotely for the first time, as we all cope with the global pandemic.

Our speakers play an essential role in the success of the conference. We welcome speakers of all backgrounds who have things they would like to share. Because we're a community-focused event based in Seattle, we are a great venue for US Pacific Northwest related stuff, but in this unusual year it will be extra-easy for you to present from almost anywhere in the world.

We especially encourage first-time and inexperienced speakers: this is a friendly place to give that first talk. We are currently doing weekly proposal review/feedback sessions as well as email proposal review and feedback. Please bring us your talk ideas and proposals and we'll help you polish them before you submit them to the CFP. See the Office Hours section of our Speaker's Guide below for details.

### CFP Dates
* CFP Closes: August 19, 2020 - Midnight PDT
* Speaker Notifications: September 11, 2020
* Schedule Published: September 25, 2020
* *SeaGL!*: November 13th and 14th, 2020

You can [submit your talk proposal here](https://osem.seagl.org/conferences/seagl2020), but we recommend taking a look at our Speaker's Guide below first for important information.

### Code of Conduct
All speakers and attendees of SeaGL must agree and adhere to the [SeaGL Code of Conduct](/code_of_conduct) for the safety and enjoyment of all organizers, volunteers, speakers, and attendees. We ask that all prospective speakers review and confirm their willingness to abide by the Code of Conduct terms and expectations when interacting with SeaGL.

All members of the SeaGL Program Committee have agreed to operate according to the SeaGL [Code of Practice](/news/2020/07/13/code_of_practice).

### Speaker's Guide
Here's some more detailed information about submitting your talk proposal to SeaGL 2020.

#### Talk Format and Timing
Talks will be presented remotely. Speakers may give their session live, or pre-record their session for the room moderator to play while they are in the chat session with the attendees.

Talk length is 20 minutes, with another 10 minutes allowed for questions, for 30m total.

We do not have longer time slots available at SeaGL 2020 because the online medium will make it more critical to present yourself concisely. Please do not propose talks that cannot be presented well within the allotted time. If you have a topic that absolutely needs more time, consider breaking your proposal into two talks: an introductory talk and a more "advanced" talk.

#### Audience Profile
SeaGL attendees are a diverse lot: in gender, race, and age, but also in technical background and open source involvement. The conference is a friendly one, with people eager to hear personal stories both of open source success and informative failure. The attendees have a high interest in open source community, particularly in ideas for promoting diversity, inclusiveness, and cooperation.

#### Talk Topics
We encourage almost any topic related to open source that you have a personal engagement with. We have created a list of topic tags you might choose to tag your proposal with — these might give you some ideas.

- Security: Security Practices (Personal and Industry) and Security Career
- Hardware: Free and Open hardware projects
- Leaving the Walled Garden: Owning Your Own Data
- Tools: Command line, databases, web tools, accessibility, open graphics tooling, and more
- Tech Culture: FLOSS for EveryOne: how can FLOSS be of help to those outside our immediate community?
- Community: Community building, labor rights, & advocacy
- Virtual meetings & "meatspace"
- DevOps: Open source DevOps, containers, continuous integration/continuous deployment, & monitoring
- Licensing & Legal
- Career Development in FLOSS software and hardware
- Performance Art! Seriously :)
- Misc: Have a great talk that doesn't fit these categories? Submit it!

#### How To Submit
Important Note: Our conference software doesn't currently support concealed reviews (talk authors are hidden from reviewers), but we do the best we can to review everything concealed anyway. For that reason, you must not include your name in your submitted abstract. The reviewers may reject proposals whose abstracts include author names.

When you are ready, submit your talk proposal to our [conference management software here](https://osem.seagl.org/conferences/seagl2020). The web form will ask you for your name, the title of your talk, and an abstract of less than 500 words that does not contain your name. The web form will also ask you to indicate whether this is your first time speaking, and whether you identify as a member of a group historically underrepresented at technical conferences. Once you have prepared and submitted this information, you may be asked for a bit more information to help identify the intended audience of your talk.

#### Talk Ideas
Not sure what to propose? Here are some ideas you might use for inspiration.
* How to get involved in free and open source software
* DevOps, system administration, infrastructure, CI/CD
* Career tips and strategies
* Web development tools and techniques
* Free and open source licensing and policy issues for users and/or developers
* Hardware, Embedded Linux, Internet of Things
* Cloud and distributed services
* Building free and open source communities
* Using free software at home, work, or school
* Free and open source relating to online security and privacy
* Writing testable open code; testing in general
* Effective documentation patterns and strategies
* Free and open software on non-GNU/Linux platforms (Windows, MacOS, etc)
These are just ideas: we would love to hear about anything that you think would be interesting to new or seasoned Free/Libre/Open source fans!

### Resources and Help
Never presented at a conference or meetup before? Presented but still not feeling confident? It's OK: even the most experienced conference presenters aren't necessarily confident at this stuff.
VM Brasseur's [Public Speaking repository](https://github.com/vmbrasseur/Public_Speaking#proposing-talks) has collected a lot of resources to help you level up your conference presenting.

Please Note: We always end up being unable to invite a bunch of really great talks. It's not you, it's us: we have a limited number of speaking slots and need to draft and balance the conference program. If we turn you down this year, we encourage you to try again in the future (here and elsewhere).

Don't let fear of rejection stop you from proposing. Please run your talk idea by us — we need you!

Office Hours: Proposal Help and Mentoring

Want to propose a talk but want feedback on your idea, proposal wording, talk title or just on how to deal with nerves? The Speaker Committee is running regular office hours online. We'll do everything we can to help you be successful with your proposal and presentation, from brainstorming to quick reviews to detailed walkthroughs.

Office hours will be held *every Wednesday at 12pm Pacific* between July 13 and August 19.

Office hours are held in the #seagl IRC channel on Freenode IRC. Don't worry if you're not familiar with IRC. You can join IRC via this [webchat interface](https://webchat.freenode.net/#seagl): choose a nickname, and you're good to go!
If you'd like assistance outside of the office hours, please email us at <cfp-help@seagl.org>.

### Final Note
It is easy but wrong to believe that you need to be some kind of professional presenter to give a good talk. SeaGL is a friendly audience who wants to hear your story! Heck, we won't even have a conference without people like you to talk to us — that's literally what this event is. Fancy slides and skilled oratory are nice, but all you really need to do is to tell people something interesting and/or fun. Don't be shy. (If you are shy, check in at our Office Hours for advice on how to tell some friendly strangers a story with less stress — a good way to turn strangers into friends.)

*We want your talk proposal!* Sorry to sound all demanding and like that, but we couldn't be more excited and pleased to work with you.  [Submit early, submit often!](https://osem.seagl.org/conferences/seagl2020).

Finally, please find the plaintext link to our submission software here: https://osem.seagl.org/conferences/seagl2020
