---
layout: post
title: 'The 2019 SeaGL CFP is open for business!'
status: publish
type: post
published: true
categories: news
tags: '2019'
---

_Calling all speakers or speakers-to-be! Our 2019 Call for Proposals is open!_

> _We are currently doing weekly proposal review/feedback sessions as well as email proposal review and feedback. Please bring us your talk ideas and proposals and we'll help you polish them before you submit them to the CFP. See the [Help and mentoring for your proposals](#help) section for more information._

SeaGL is dedicated to supporting newer speakers. We welcome speakers of **all backgrounds and levels of experience** – even if you’ve never spoken at a technical conference. If you’re excited about Free/Libre/Open technologies or communities, then we want to hear from you!

Because we're a community-focused event based in Seattle, we're particularly interested in hearing from new and experienced speakers from the Seattle and Pacific Northwest region, but we welcome proposals from anyone no matter where you're based.

Here's what we cover in this CFP announcement. We know it's rather a lot, so you can click to jump to the section you need (but we encourage you to read it all through at least once).

* [CFP dates](#dates)
* [Audience profile](#audience)
* [Talk formats](#formats)
* [Talk categories (aka Tracks)](#tracks)
* [Topic ideas](#ideas)
* [PLEASE don't do this…](#nope)
* [How To Submit](#howto)
* [Proposal and public speaking resources](#resources)
* [**Help and mentoring for your proposals**](#help)
* [Speaker travel support](#travel)
* [Code of Conduct](#coc)
* [Code of Practice](#cop)
* [Click here to propose a talk](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## CFP dates <a name="dates"></a>

* CFP Opens: June 24th, 2019
* CFP Closes: August 11th, 2019 - Midnight PDT
* Speaker Notifications: September 15th, 2019
* Schedule Published: October 8th, 2019
* SeaGL!: November 15-16, 2019

## Audience profile <a name="audience"></a>

SeaGL is honored to be hosted by [Seattle Central College](https://seattlecentral.edu/). Because our event occurs partly during their school week, we have not one but two audiences. Both audiences are present both days of the event, but each day has a larger proportion of one type of audience member:

1. Friday: School is in session on this day, so many of our attendees are community college students. We try to schedule more "Free/open source 101" type talks on this day to help the students get a firm grounding in FOSS and its technologies.
1. Saturday: Weekend! We have fewer students on this day and more professionals and hobbyists. This audience is more familiar with technology in general and often is looking for more advanced talks or introductory talks on more advanced topics.

## Talk formats <a name="formats"></a>

Like the last few years, in 2019 SeaGL is looking for talks in two formats:

* **20 minutes**: Introduce the audience to a new technology, concept, or just recap an older idea which you think is really neat.
* **50 minutes**: Go more in depth! Do a demo! This is your chance to really educate the audience about something you enjoy.

Both of these time slots **include the Q&A time**. Please time your presentations accordingly. We suggest aiming for a 15 minute presentation for the 20 minute time slot and for 40-45 minutes for the 50 minute time slot, but as the speaker the final presentation time is up to you (as long as you don't exceed your time slot).

We do **not** have workshop (60+ minute) slots available at SeaGL and will not be opening any. Please do not propose talks that cannot be presented well within the two time slot options above.

[Click here to propose a talk.](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## Talk categories (aka Tracks) <a name="tracks"></a>

SeaGL doesn't do "tracks" like many other conferences do, but we do use tracks to make sure we have a nice balance of subjects covered during the event. Think of them more like _categories_ than _tracks_ in the traditional tech conference sense. This year you can select from one of the following categories when creating your proposal:

* Data/AI/ML
* Design/UI/UX/Accessibility
* Documentation
* Education
* Hardware/IoT
* Legal/Licensing
* People
* Programming
* Security/InfoSec
* Something different
* Systems/Ops

Don't worry if your talk isn't a snug fit with any of these categories. It's not a problem and we don't mind at all. Just pick the one that's the closest fit, and if nothing else please do use the _Something different_ category.

[Click here to propose a talk.](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## Topic ideas <a name="ideas"></a>

Not sure what to propose? Here are some ideas!

* How to get involved in free and open source software
* DevOps, system administration, infrastructure, CI/CD
* Career tips and strategies
* Web development tools and techniques
* Policy and licensing affecting free and open source software use or development
* Hardware, embedded Linux, or the Internet of Things
* The cloud and other distributed services
* Building free and open source communities
* Using free software at home, work, or school
* Security and privacy online
* Writing testable code, and testing in general
* Effective documentation patterns and strategies
* Free and open software on non-GNU/Linux platforms (Windows, macOS)
* Anything else that you think would be interesting to new or seasoned Free/Libre/Open source fans!

[Click here to propose a talk.](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## PLEASE don't do this… <a name="nope"></a>

Our conference software doesn't currently support concealed reviews (where the reviewers can't see who proposed a talk), but we do the best we can to review everything concealed anyway.

Because of that, **DO NOT INCLUDE YOUR NAME IN YOUR ABSTRACT**.

Your name is for your bio, not for your abstract. If you include your name in your abstract, **you are at risk of having your proposal voted down and not accepted.**

We really can't stress this enough. Don't do this. Really.

## How to submit <a name="howto"></a>

First, [Click here to propose a talk.](https://osem.seagl.org/conferences/seagl2019/program/proposals) This screen will ask you for your name, the title of your talk, and an abstract. The abstract needs to be less than 500 words. Indicate whether or not this is your first time speaking, and/or if you identify as a member of a group historically underrepresented at technical conferences.

Then, you'll hit submit. Notice that there is now a link asking for you to Complete Your Proposal. At this link, you can add Track and Difficulty, and edit any of the other fields that you have already filled.

[Click here to propose a talk!](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## Proposal and public speaking resources <a name="resources"></a>

Never presented at a conference or meetup before? Presented but still not feeling confident? It's OK, even the most experienced conference presenters aren't necessarily confident at this stuff.

VM Brasseur's [Public_Speaking](https://github.com/vmbrasseur/Public_Speaking) repository has collected a lot of resources to help you level up in your conference presenting.

Pay particular attention to the [Proposing talks](https://github.com/vmbrasseur/Public_Speaking#proposing-talks) section of this page. Follow these tips and your talk proposals will stand a better chance of being selected.

**PLEASE NOTE**: Whether your talk is accepted or not often doesn't have as much to do with how great your proposal is as it does with how many speaking slots the conference has available and the balance of the program the organisers need to craft. It's nothing personal: we just don't have enough time to accept all the great talk proposals we receive.

Don't let that stop you from proposing! You can't win a race you don't even run, so [click here to propose a talk.](https://osem.seagl.org/conferences/seagl2019/program/proposals)

## Help and mentoring for your proposals <a name="help"></a>

Want to propose a talk but want feedback on your idea, proposal wording, talk title or just on how to deal with nerves? The speaker committee is running CFP office hours during the CFP. We'll do everything possible to help you be successful with your proposal and presentation. Office hour times to come shortly, probably a time or two on a regular schedule each week.

<!-----* 12-1 PM Pacific Time, every Wednesday until the CFP closes August 7th, as well as one last session August 11th ([when is that in my local time zone?](https://everytimezone.com/#2019-8-7,420,b8jj)) ---->

All office hours are held in the `#seagl` IRC channel on Freenode IRC. Don't worry if you're not familiar with IRC. Just [click here for the webchat](https://webchat.freenode.net/?channels=%23seagl), choose a nickname, and you're good to go!

If you'd like assistance outside of the office hours, please email us at [cfp-help@seagl.org](mailto:cfp-help@seagl.org). We welcome all questions that arrive between June 4th and July 29th.

## Speaker travel support <a name="travel"></a>

As SeaGL is a **free to attend community-oriented and -organized conference**, we regret that we are unable to help with the cost of travel and accommodation for speakers at this time.

## Code of Conduct <a name="coc"></a>

All speakers and attendees of SeaGL must agree and adhere to the [Code of Conduct](/code_of_conduct) for the safety and enjoyment of all organizers, volunteers, speakers, and attendees. We ask that all prospective speakers review and confirm their willingness to abide by the Code of Conduct terms and expectations when interacting within SeaGL community spaces.

## Code of Practice <a name="cop"></a>
All members of the SeaGL Program Committee have agreed to operate according to our [Code of Practice](/news/2019/06/25/code_of_practice).

[No, really, click here to propose a talk. Please. We want to hear from you!](https://osem.seagl.org/conferences/seagl2019/program/proposals)
