---
layout: post
title: 'CFP Acceptances by the Numbers'
status: publish
type: post
published: true
categories: news
tags: '2018'
image: /img/posts/seagl2018-tracks.png
---

All talk proposal notifications went out this morning. While we're still waiting for speakers to confirm they can do the selected talks, we thought it would be interesting to share some more numbers now that the schedule is taking shape.

## Method

Our selections are based almost entirely upon raw score data. To put it simply: the highest-rated talks were accepted, with the caveat that we only accepted one talk from any proposer.

Normally we'd look at the raw scores and then massage things a bit to get a better balance of topics and speakers, but that was not necessary. The proposals we received this year were so good and so diverse that no program-massaging was necessary at all. The straight numbers were pretty much all we needed.

And speaking of numbers…

## 55 talks accepted

We received 163 proposals and accepted 55 of them. That's a 33.7% acceptance rate.

The majority of declined talks were due to us accepting only one talk per speaker. A lot of folks proposed several talks, so they received several decline emails.

We're _very_ grateful that people proposed multiple talks. It allowed us a lot of flexibility in creating a well-balanced and interesting program. Next year, though, we'd like to consolidate to a single decline email if possible. It's more humane than, for instance, one acceptance email and six decline emails (as one of our proposers received).

## Break down by track

[![Bar chart of accepted talks, broken down by track](/img/posts/seagl2018-tracks.png){:width="400"}](/img/posts/seagl2018-tracks.png)

Sysadmin/Ops/DevOps was far and away the most popular track among the accepted talks, but Programming and InfoSec weren't too far behind.

Bringing up the rear is Data/AI/ML with only a single accepted talk. Considering the current popularity of AI and Machine Learning, we were really surprised we didn't receive more good proposals on this topic.

Regardless, the SeaGL schedule is going to have something for everyone. We're very pleased with the diversity of topics represented.

## 27% 20-minute talks

Last year we introduced the 20-minute talk option and we had 14 talks of that length on the schedule.

This year we have 15 20-minute talks on the schedule (so far), which is nice and consistent.

## 13% first-time presenters

[![Pie chart of first time presenter stats showing 13% of accepted SeaGL 2018 presenters are new to tech conference speaking](/img/posts/seagl2018-1sttimers.png){:width="400"}](/img/posts/seagl2018-1sttimers.png)

SeaGL believes in building the Free Software and open source community of the future and part of that is supporting new conference speakers.

We're pleased that 13% of our acceptances this year were from people who have not presented at a conference before.

We would like to improve this number in future years, but when 6.4% of the total number of proposals were from people who self-identify as first time speakers, we think that 13% is still pretty darn good.

Welcome to presenting! We're happy to have you at SeaGL.

## 44% under-represented presenters

[![Pie chart of diversity stats showing 44% of accepted SeaGL 2018 presenters self-identify as a member of a group that's under-represented in technology.](/img/posts/seagl2018-diversity.png){:width="400"}](/img/posts/seagl2018-diversity.png)

A full 44% of the accepted talks come from people who self-identify as a member of an under-represented group in technology.

We're particularly proud of this number, we have to confess. We work very hard to make SeaGL a safe space for all people. With numbers like this, it looks like the word is getting out. We're very honored that people trust us to continue having a welcoming environment.

It's only through embracing, increasing, and fostering diversity in technology that we'll be able to improve and spread the ethos of Free Software. Thank you, SeaGL attendees and staff, for helping with this and keep up the great work.

## Schedule caveat

These numbers are just for the initial acceptances. Due to speaker schedules and obligations, some of them may not be able to present at SeaGL in November. Therefore the final schedule may not reflect these exact numbers as we sub in someone from the waitlist.
