---
layout: post
title: 'Talk Proposal Selection Criteria'
status: publish
type: post
published: true
categories: news
tags: '2018'
---

We like to be free and open around here at SeaGL, and that includes transparency around a lot of our processes. This post is the instructions we provided to our review committee on how they should rate the 160+ talk proposals we received. We hope that these instructions will not only help people craft better proposals in the future, but also help other events who may be looking for guidance on how to review their own proposals.

## Audience profile

The audience runs the gamut from experienced FOSS technologists to the uninitiated/students, leaning quite heavily to the latter rather than the former.

Therefore talks about how to scale your unicorn are less applicable than more introductory topics.

Which isn't to say there's no space for unicorn scaling type talks, just that they will be in the minority for the program.

This is also a much less corporate conference/audience than, say, [SCALE](https://www.socallinuxexpo.org/scale/16x)/[OSCON](http://oscon.com)/[ATO](https://www.allthingsopen.org/)/etc. Our event is free to attend, so it attracts those who are interested in or passionate about technology more than those who are getting their company to pay for them to attend for training purposes. This also means that most of the audience will be very local to the Seattle region.

## Criteria

* Please remember the [Code of Practice](/news/2018/04/09/code_of_practice)
* Our CFP system can't do blind reviews, but try to do as blind as possible (the abstract/content is more important than the presenter, on first pass at least)
* Only vote on talks which you feel qualified to judge
    * Leave stars blank else
    * Exception: something which sounds so cool or so crappy that you feel compelled to vote
* Don't vote on withdrawn or rejected talks
    * OSEM keeps these in the list, sorry
    * Sorting list by 'State=new' can help limit these review misfires
* Keep the audience needs front and centre
    * "Yeah, I would like to see this" is **NOT important**
    * "Yeah, the audience would get value out of this." is **VERY important**
    * Therefore, if an abstract has no clear audience takeaways, please vote it down
* No advertisements or sales pitches allowed
    * Please vote down anything that looks like it'll be a pitch
* GNU/Linux/Free Software not required
    * Yes, it's the Seattle GNU/Linux conference
    * No, we're not bigots against non-Free (as in speech) technologies
    * That said, proposals predominantly about proprietary technologies should be voted down
* Proposals including questionable language/messaging should be voted down
    * Language/platform/community shaming
    * Colloquialisms based in or statements implying or outright stating racism, sexism, anti-LGBTQ-ism
    * Mean-spirited or rude language
    * Etc.
* Non-software tech is welcome
    * For instance, in 2016 we had a very well received talk about WW1 technologies
* And, naturally, please don't vote on your own talks

## Process

* The workflow
    * View the Events on the conference site
        * OSEM calls proposals "Events"
    * View each event
        * You'll probably either have to open each in a new tab/window or do a lot of click-vote-go_back action
        * Apologies for the cumbersome UI/UX here
    * Vote & optionally comment
    * Repeat until done
* Meaning we'll use for the stars:
    * none: Did not vote
    * ⭐️: No way, nuh uh, hell no, nope
    * ⭐️⭐️: Meh, maybe, could work
    * ⭐️⭐️⭐️: Yup, I'd like our audience to see this
* Whether you vote on a proposal or not, feel free to add a comment
    * Proposers can NOT see these comments (but be nice anyway)
    * Admins CAN see these comments
    * Reviewers can see these comments if they click through
