---
layout: post
title: 'SeaGL speaker Q&A: Paul English'
status: publish
type: post
published: true
categories: news
tags: '2017'
---

Paul English gives his talk titled, "Detecting BadBIOS, Evil Maids, Bootkits, and Other Firmware Malware" on [Friday afternoon](https://osem.seagl.org/conferences/seagl2017/program/proposals/374).

Q: Could you please introduce yourself and tell us a little about your background?

A: I'm the CEO of a startup, PreOS Security working on platform firmware security. Previously I was a system and network administrator, and a manager of sysadmins. I bring a defensive IT perspective to our business, and I'm trying to pick up sales and marketing skills as quickly as I can. My business partner and PreOS Security CTO Lee Fisher has given talks about platform firmware and UEFI security at SeaGL and LinuxFest Northwest in the past, and brings the firmware level expertise. Lee ran and continues to run the best blog on [this topic](https://firmwaresecurity.com).

Q: Without tipping your hand on the actual talk, can you give us an idea of what we might expect?

A: Everyone, always needs to know more about cybersecurity these days - as our lives are increasingly digital, cybersecurity is just plain security. Part of life. The recent Equifax breaches illustrate the issue. Platform firmware (as opposed to IoT style "full blown operating system-as-firmware") is an obscure area, but steadily increasing in importance. The saying in the field is "firmware is the new software." I think in future years, scanning your firmware for malware and viruses will be just as important as operating system and application level protection. While you might gain some level of protection from attacks by running Linux or FreeBSD, as a smaller target than Windows, you'll still be using the same firmware as everyone else! We're in the early days, so expect a fairly technical talk, with examples of firmware-level hacks and what to expect as attacks evolve.

This seems like a good time to mention that attendees will get access to our upcoming ebook, tentatively titled "Firmware Security for Everyone" aimed as much as possible at the average person with several computing devices to manage. Everyone is a sysadmin for their own system these days. We'll also give access to our ebook "Firmware Security for Sysadmins" aimed at people managing much larger fleets of machines.

Q: Is this your first visit to SeaGL? If so, what are your expectations? If not, can you give us your impressions of the event?

A: I love SeaGl, and I've attended every year (except last year, unfortunately), and spoken before on "So You Want to Be a Sysadmin."  There's nothing quite like a gathering of people all passionate about a given subject, enough to put on an event of this scale. And of course, I'm passionate about open source and Linux!

Q: Other than speaking at SeaGL, how do you contribute to OSS?

A: Like most people in the community, I've always provided a some amount of free technical support to and the occasional bit of documentation to help others. But I'm more excited about my first ever real open source standalone application in the form of the upcoming [PreOS Security firmware scanning software](https://preossec.com/). While my business partner has written most of the code, it is still exciting for me to be involved in a standalone application from start to release.
