---
title: Opening up the World of WebAssembly with Guile Hoot
osem_url: https://osem.seagl.org/conferences/seagl2023/program/proposals/977
beginning: '2023-11-03T16:40:00.000-07:00'
end: '2023-11-03T17:30:00.000-07:00'
resources:
  internet_archive_identifier: SeaGL2023-Opening_up_the_World_of_WebAssembly_with_Guile_Hoot
presenters:
- name: David Thompson
  affiliation: Spritely Institute
  osem_url: https://osem.seagl.org/users/1654
  gravatar_id: 057d0f1dd4310f64888a8d503247d55d
  biography: David Thompson is a software engineer and free and open source software
    advocate who enjoys writing software at every level of the stack.  He is currently
    the Core Infrastructure Architect at the Spritely Institute. Prior to Spritely,
    David was a DevOps engineer and full-stack web developer for Vista Higher Learning
    where he worked on everything from product feature implementation to production
    infrastructure automation. He is also a former web developer for the Free Software
    Foundation, has made numerous contributions to free software projects such as
    Guile and Guix, and has built his own game development and web development tools
    in Scheme.
- name: Robin Templeton
  affiliation: Spritely Institute
  osem_url: https://osem.seagl.org/users/1655
  gravatar_id: d646613777fda569f8842647db325419
  biography: |-
    Robin Templeton is a free software advocate who enjoys working on compilers, programming language design, and exploring system architecture. Their enduring fascination with Lisp environments and distributed object capability secure programming naturally lead them to an interest in the Spritely Institute, where they currently work as a compiler engineer focused on the Guile Hoot project.

    Robin's previous work spans working on compilers at Igalia (including building the JavaScript BigInt implementation in Firefox, used by millions of users every day), building a variant of GNU Emacs which runs on top of GNU Guile, working on game development tools for Tech Drone, and volunteering for HCoop.net (including nine years serving on the board of directors).

    If given the opportunity and interest, they will bless an interested listener with a treasure trove of obscure Lisp history.
---

Guile Hoot is a free and open source WebAssembly toolchain and Scheme compiler that is opening doors for all programming languages to run within the web browser. The Guile Hoot project is being developed by the Spritely Institute, a 501(c)(3) nonprofit organization, as part of its mission to build the next generation of decentralized infrastructure for networked communities.

In this talk, we'll cover:

* What is WebAssembly and why is it important?
* What is Guile Hoot and what makes it special compared to other WebAssembly projects?
* How does building a Scheme compiler help other programming languages such as Python and Ruby?
* How does Guile Hoot fit into the Spritely Institute's mission?
* How can I get involved in this effort?

Along the way, we will show several code examples and live demos of applications built with Guile Hoot.
