---
title: How do you build LEGOs for code?
osem_url: https://osem.seagl.org/conferences/seagl2023/program/proposals/971
beginning: '2023-11-04T17:10:00.000-07:00'
end: '2023-11-04T17:30:00.000-07:00'
resources:
  internet_archive_identifier: SeaGL2023-How_do_you_build_LEGOs_for_code
presenters:
- name: Chris Thompson
  osem_url: https://osem.seagl.org/users/1650
  gravatar_id: f50d455899aac63a09168087aa9c0baa
  biography: I have spent a lot of time as a security engineer, but I think I really
    am more of a developer. I like when things go together nicely without too much
    overhead and I strive to make that happen. I like to bake, I have a pie instagram
    @sogoodicouldpie, and I like to rollerblade. I also have been streaming the development
    of protoflow if you are interested, breadchris on youtube.
---

gRPC is as close as we have come to having LEGOs as code. A battle tested type system with a focus on simplicity and scalability. By not having focus on a market outside of the needs of large technology companies, it has been unable to make a meaningful impact for smaller teams or individuals. Countless hours are spent in whiteboard sessions determining what language to use, what libraries to use for connecting a third party REST API, etc. All of this effort distracts from the true goal of modeling data and transforming it. Inefficiency in standardization of interprocess communication costs much more than inefficiency in compute and storage for most common tasks.

By building tools which make it easy to see how one block connects to the other, this opens the door for other people in an org to become developers. Platforms such as [IFTTT](https://ifttt.com/) and [Zapier](https://zapier.com/) have demonstrated the desire for people in a company to harness the power of effective primitives to construct their own workflows. Yet there is still exists a gap for developers to contribute their own extensions using a language and environment they are familiar with.

Protoflow is built on open source technology that has scaled Google and Uber, and provides the much needed tooling for developers to harness this power. Having taught a number of high school students, it is amazing what they can do so quickly. If Protoflow lives up to really embracing what Heroku had with the [twelve-factor app](https://12factor.net/) and can truly deliver on “composable code”, the creativity kids are spending on Minecraft and Roblox could be channeled into building code that provides actual value. If a person with an idea for an app can build their entire app and start it out being hosted for free (just like Heroku did) even with minimal resources it could change their life.
