---
title: Beyond Trusting FOSS
osem_url: https://osem.seagl.org/conferences/seagl2023/program/proposals/939
beginning: '2023-11-04T12:00:00.000-07:00'
end: '2023-11-04T12:20:00.000-07:00'
resources:
  internet_archive_identifier: SeaGL2023-Beyond_Trusting_FOSS
presenters:
- name: Vagrant Cascadian
  affiliation: Reproducible Builds, Debian, Aikidev
  osem_url: https://osem.seagl.org/users/353
  gravatar_id: c1d2ee04b413cf2fbbb4d639a1862d93
  biography: Vagrant is a free software developer involved in the the Debian project,
    a system administrator for an ARM build farm for Reproducible Builds, and gets
    thrown around repeatedly as a hobby. You can find vagrant on social networks such
    as the OpenPGP web of trust and the Debian Bug Tracking system!
---

Software released under a FOSS license and developed using an
FOSS model come with many benefits, allowing the ability to
use, study, change, and share not only the software itself, but
similarly engage with a community around the software in a transparent
manner.

One of the strongest assertions of open-source software is that it is more
secure, as many parties are able to independently inspect the code...

Most code in the modern day is distributed as precompiled binary code,
indistinguishable from gibberish to even very savvy humans; this makes
the binary code largely impractical to audit. Blind trust is a
frightening security model!

Reproducible Builds provides a way to build trust that the binaries
produced are the intended result of the source code, by making it
possible for independent third-party verification of binaries to
produce bit-for-bit identical binaries.

This talk will introduce the concepts of Reproducible Builds,
including best practices for developing and releasing software, the
tools available to help diagnose issues, and touch on progress towards
solving decades-old deeply pervasive fundamental security issues...

Learn how to verify and demonstrate trust, rather than simply hoping everything is OK!

<https://reproducible-builds.org>
