---
title: Let's Make Games with Rust
osem_url: https://osem.seagl.org/conferences/seagl2020/program/proposals/737
beginning: '2020-11-13T14:00:00.000-08:00'
end: '2020-11-13T14:30:00.000-08:00'
resources:
  internet_archive_identifier: SeaGL2020-Elijah_C_Voigt-Lets_Make_Games_with_Rust
presenters:
- name: Elijah C. Voigt
  affiliation: CloudBolt Software
  osem_url: https://osem.seagl.org/users/369
  gravatar_id: 4849a5aa9981c25518cc46c595a729ca
  biography: Elijah has been a Linux Users Group President, is a Software Developer
    at the OSU OSL, and has given talks internationally! He currently works as a software
    dev at CloudBolt Software writing Django.
---

In this talk we will write a small game in Rust using the Amethyst game engine. You will learn about Rust as well as some basic game programming principles like the Entity, Component, System (ECS). You will not need prior experience with games programming, Rust, nor Amethyst, but a passing familiarity with Rust will give you a head start.

Game's industry software is largely dominated by C and C++. These languages are fast and productive, but they can also be buggy and prone to catastrophic programming errors.

Enter: the Rust Programming Language. Rust is a safe yet powerful systems programming language. Rust looks and acts a lot like C++, but guarantees safety from pesky memory bugs that countless RFCs have been written about.

Rust's safety is most critical in device drivers and life support software, where a crash can mean life and death, but we can also use it to make games?

Enter: the Amethyst Game Engine. Amethyst is a fully open source game engine written in Rust. Amethyst provides tools for writing 2D and 3D games and implements many industry standards like an ECS framework, and data-driven design. Not sure what those works mean? Come find out!
