---
title: Building Free CI/CD with GitHub Actions
osem_url: https://osem.seagl.org/conferences/seagl2020/program/proposals/769
beginning: '2020-11-14T10:00:00.000-08:00'
end: '2020-11-14T10:30:00.000-08:00'
resources:
  internet_archive_identifier: SeaGL2020-Cameron_Bielstein-Building_Free_CI_CD_with_GitHub_Actions
presenters:
- name: Cameron Bielstein
  affiliation: Allen Institute
  osem_url: https://osem.seagl.org/users/1057
  gravatar_id: 887d4b9a81eece116fbfca540d5503cf
  biography: Cameron Bielstein is a software engineer at the Allen Institute for Brain
    Science in Seattle. He holds a Master of Science in Computer Science from The
    University of Texas at Austin and is a proud community college graduate. Additional
    professional experience includes time at Microsoft, some freelance experience,
    and volunteering to mentor computer science students. When not writing code, Cameron
    can be found playing with his dog, eating tacos, or sailing.
---

Build free CI/CD for your open source repository!

Continuous integration and continuous deployment (CI/CD) is a popular DevOps method of ensuring software quality and velocity in a modern development environment through automated builds, tests, and deployments.

GitHub Actions is GitHub's built-in workflow framework for tasks such as CI/CD and more. It is fully integrated with GitHub repositories and, best of all, it is completely free for open source!

This hands-on demonstration will go from zero to fully functional CI/CD pipeline in under 20 minutes using GitHub Actions. Attendees will come away with the skills and knowledge (and sample code) necessary to configure automated PR builds, test runs, and continuous deployment for own projects.

This talk is an introductory talk to GitHub's CI/CD offering and is suitable for all experience levels. Content will include introductions of concepts, a "live" coding demonstration of building a GitHub Actions, and time for questions and answers.
