---
title: Privacy, Decentralisation and Scaling with IPv6 Multicast
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/654
beginning: '2019-11-15T10:45:00.000-08:00'
end: '2019-11-15T11:35:00.000-08:00'
resources:
  internet_archive_identifier: multicast
presenters:
- name: Brett Sheffield
  affiliation: Librecast
  osem_url: https://osem.seagl.org/users/917
  gravatar_id: 56774668d3beaa0296114627972b46e0
  biography: |-
    Brett is a hacker, entrepreneur and technologist, working at the intersection of human rights and technology, particularly in the areas of privacy and Internet decentralization.

    He lives with his wife on a little farm in central France where he drives tractors, does rude and unusual things with IPv6 and multicast, and studies foreign languages.

    Brett is concerned that our Internet is under threat from Criminals, Corporations and Governments alike, and is trying to do something about it. If you are too, he'd love to hear from you.
---

Written in 2001, RFC 3170 states: *"IP Multicast will play a prominent role on the Internet in the coming years. It is a requirement, not an option, if the Internet is going to scale. Multicast allows application developers to add more functionality without significantly impacting the network."*

Nearly two decades later, multicast is still largely ignored and misunderstood. There are many common misconceptions about multicast, including that it is only useful for streaming video and audio. It does so much more than that.

This talk explains why multicast is the missing piece in the decentralisation puzzle, how multicast can help the Internet continue to scale, better protect our privacy, solve IoT problems and make polar bears happier at the same time.

At a time when even the web is moving to UDP with HTTP/3 and WebRTC, it is time we took a serious look at what we're missing by not using multicast at the network layer to underpin our Internet protocols. We'll discuss how you can start using multicast in your project today, and how multicast design and thinking differs from unicast. We'll cover some of the different types of IP multicast, the basics of multicast routing and how to build in TCP-like reliability.
