---
title: "Open Source Won, but Software Freedom Hasn't Yet: A Guide & Commiseration
  Session for FOSS activists"
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/659
beginning: '2019-11-16T13:00:00.000-08:00'
end: '2019-11-16T13:50:00.000-08:00'
presenters:
- name: Bradley M. Kuhn
  affiliation: Software Freedom Conservancy
  osem_url: https://osem.seagl.org/users/356
  gravatar_id: 9ce917491592ab7c3db27a0a3d5842ab
  biography: "[Bradley M. Kuhn](http://ebb.org/bkuhn/) is the [Policy Fellow and Hacker-in-Residence](https://sfconservancy.org/about/staff/#bkuhn)
    at [Software Freedom Conservancy](https://sfconservancy.org/) and editor-in-chief
    of [copyleft.org](https://copyleft.org). Kuhn began his work in the software freedom
    movement as a volunteer in 1992, as an early adopter of Linux-based systems and
    contributor to various Free Software projects, including Perl.  He worked during
    the 1990s as a system administrator and software developer for various companies,
    and [taught AP Computer Science](http://www.ebb.org/bkuhn/blog/2007/05/05/walnut-hills-1998.html).
    \ Kuhn's non-profit career began in 2000 at the Free Software Foundation (FSF).
    \ As FSF's Executive Director from 2001&ndash;2005, Kuhn led [GPL enforcement](https://www.fsf.org/licensing),
    launched [its Associate Member program](https://www.fsf.org/associate/), and invented
    [the Affero GPL](https://www.gnu.org/licenses/agpl-3.0.html).  Kuhn began as Conservancy's
    primary volunteer from 2006&ndash;2010, and became its first staffer in 2011.
    \ Kuhn holds a B.S. in Computer Science from [Loyola University in Maryland](https://www.loyola.edu/academics/computer-science),
    and an M.S. in Computer Science from the [University of Cincinnati](http://www.cs.uc.edu/).
    \ Kuhn has [a blog](http://ebb.org/bkuhn/blog/) and co-hosts the audcast, [*Free
    as in Freedom*](http://faif.us/)."
- name: Karen M. Sandler
  affiliation: Software Freedom Conservancy
  osem_url: https://osem.seagl.org/users/951
  gravatar_id: 9fc82ecb56b6f422a52f940392733e8d
  biography: |-
    Karen M. Sandler is the executive director of the Software Freedom Conservancy, which is the nonprofit home of dozens of free and open source software projects including Git, Etherpad, QEMU, Selenium and Inkscape (to name a few). She is known as a cyborg lawyer for her advocacy for free software as a life-or-death issue, particularly in relation to the software on medical devices.

    Prior to joining Conservancy, she was the executive director of the GNOME Foundation. Karen co-organizes Outreachy, the award-winning outreach program for people who are subject to systemic bias and underrepresented in tech. Karen is an adjunct Lecturer-In-Law at Columbia Law School and Visiting Scholar at UC Santa Cruz as an advisory committee member of the Center for Research in Open Source Software. She is the recipient of the Free Software Foundation's 2017 Award for the Advancement of Free Software as well as an O'Reilly Open Source Award.
---

History never unfolds as we would expect.  It's surprising and jarring that we've achieved both so much and so little.  Every day, there is more Free and Open Source Software (FOSS) in the world than ever in history, but it's also a little bit harder each day to live a life that avoids proprietary software.  Today's world of software technology is a ridiculous paradox.

Most software that we depend on every day is under someone's else control.  Whether it's the cloud service run by a big company, the medical devices that keep us alive, or the Javascript application for everything from our banking to our social media, the code that handles our most sensitive data and life-essential computing tasks is usually proprietary.  Even Linux-based devices, which are ubiquitous, rarely comply with the GPL and therefore are more-or-less almost as proprietary as any other device.  Linux is everywhere, yet early FOSS adopters have never had less software freedom than we do today.

Once upon a time, it was viable for someone living in the industrialized world to function in daily society in pure software freedom.  In those days, being a software freedom activist was akin to being a vegan or vegetarian: activists could (relatively conveniently) live a lifestyle that reflected our values and proved our sociopolitical point in mundane, daily terms.

Leading by example is not so easy anymore.  The strongest supporters of software freedom among us, if they chose to remain living in the industrialized world, make compromises.  Our political opponents tell us that our cause is misguided since these compromises "aren't so bad".  Meanwhile, our would-be political allies question our commitment to the cause because we carry devices with some proprietary firmwares.  Navigating this complex climate may well be the hardest challenge we face.

Cooptation is a commonplace for social justice movements, and the cooption process can be ongoing for decades.  The software freedom movement is a few years into this cooption: this is precisely why we see major leaders stand up and shout "Open Source is the default; Open Source has won!" while presenting slides from a Macbook.  The most difficult days don't lie behind us; they lie ahead.

This talk is about surviving the personal struggle of software freedom activism in this current climate.  Many of us want a world with only FOSS and no proprietary software, but we won't get there in our lifetimes.  How do we live our lives to maximal effect to carry forward the torch of software freedom both in this generation and onto the next?  How do we weather the inevitable failures and seemingly insurmountable challenges as we watch what was once FOSS slowly become proprietary again, or see new technologies exist only as proprietary, or, even worse, exist as a warped version of FOSS that "seems open" but fails to give most software freedoms to most users?  Let's learn and explore together how to survive as activists now that the going got tough.
