---
title: Once more with style
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/670
beginning: '2019-11-16T14:00:00.000-08:00'
end: '2019-11-16T14:20:00.000-08:00'
presenters:
- name: John SJ Anderson
  affiliation: Infinity Interactive
  osem_url: https://osem.seagl.org/users/355
  gravatar_id: 53ac84863938e5f4b28b2d2a2b4a81fb
  biography: John is the VP of Technology for Infinity Interactive, a technology consultancy
    and bespoke software development shop. When he's not madly trying to keep up with
    the pace of change in Javascript development, maintaining Perl modules, or tweaking
    his Emacs config, he likes to play around with new languages like Swift and Rust
    and write about himself in the third person.
---

Would your Open Source software project benefit from a style guide? Would your project at work? It's tempting to reply to these questions with a reflexive "Yes, of course!" — the benefits of having an established coding style for a project, having rules around how things are formatted, what language features are to be used and which are to be avoided, seem obvious. It makes it easier to onboard new contributors, establishes a baseline expectation for drive-by pull requests, and makes the code review process more transparent.

But style guides aren't free. Setting one up can involve a significant amount of effort, and, depending on the number of contributors involved in the discussion, can be a significant source of stress and strife. Many projects have been highly successful with nary a hint of any sort of overall style guidance.

So what's a maintainer to do? Style guide, or no? Come to this talk to learn more about the tradeoffs between having a style guide and not having a style guide, as well as some tooling options that you may not be aware of that will make it easier to move towards having some style guidelines, without having to invest a bunch of upfront effort into something you may end up hating.
