---
title: Old Dogs & New Tricks
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/668
beginning: '2019-11-15T14:45:00.000-08:00'
end: '2019-11-15T15:05:00.000-08:00'
presenters:
- name: John SJ Anderson
  affiliation: Infinity Interactive
  osem_url: https://osem.seagl.org/users/355
  gravatar_id: 53ac84863938e5f4b28b2d2a2b4a81fb
  biography: John is the VP of Technology for Infinity Interactive, a technology consultancy
    and bespoke software development shop. When he's not madly trying to keep up with
    the pace of change in Javascript development, maintaining Perl modules, or tweaking
    his Emacs config, he likes to play around with new languages like Swift and Rust
    and write about himself in the third person.
---

The Perl programming language has a somewhat checkered reputation. People enjoy ranting about the supposed "read-only" nature of the language, and war stories of having to maintain horrible legacy Perl codebases are a popular feature of after-hours gatherings at programming conferences around the world. But, as Bjarne Stroustrup notes, "There are only two kinds of languages: the ones people complain about and the ones nobody uses" -- and Perl also enjoys a reputation as a language that gets pulled out when you need just a bit more "oomph" on the command line than you can muster up with bash, sed, awk, and friends.

The thing that most people don't realize is that the Perl5 community, after a brief period of reduced activity in the early 2000s, has regained velocity and organization, and has produced new stable language releases (with new features!) for the last 9 years (and counting). During that period of time, the community consensus around issues such as installation management, deployment, and other best practices has undergone significant evolution. New libraries and frameworks have been introduced and have replaced older standards that you may be familiar with. (CGI.pm? No more!) As people from the Perl community have gained experience with newer languages and frameworks, they've brought new ideas from those systems back into the Perl fold, either adding them to the core language or to libraries available on the CPAN. The result combines all the stability from Perl's overarching commitment to backwards compatibility with support for the newest protocols and programming paradigms.

This talk will summarize significant new features that have been added to the core language, discuss tooling options for managing Perl installations, explain the community consensus on best practices around deployments and which competing libraries to use for particular purposes, and generally get you up to speed on how the Perl5 community thinks about development in Perl in 2019.

If you learned Perl back in the 5.6 days, you'll find out about all the new things you can start using that will make your Perl code even better. If you never learned Perl -- and especially if you think Perl is horrible -- you might just find out that it's not quite as bad as you've heard. You may even find a new feature or two that you'll want to steal and re-implement in your favorite programming language.
