---
title: Left Shift Security (LS^2) = Shifting Application Security Left
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/677
beginning: '2019-11-16T14:45:00.000-08:00'
end: '2019-11-16T15:35:00.000-08:00'
presenters:
- name: Nadine Whitfield
  affiliation: ThoughtWorks
  osem_url: https://osem.seagl.org/users/916
  gravatar_id: 45667978e106a2e3aae5a7cf6e9c8148
  biography: Polyglot developer with an eye towards security, automation and quality.
---

*I will be sharing my learnings about security testing applications sooner and more often. Let's start a movement!*

CI/CD has greatly reduced the time to market for releasing new software.
Security and InfoSec are rapidly gaining importance and complexity, but unfortunately their supporting processes and tools have not benefited as much from automation and modernization as other processes and tools used by development teams.

Security testing is challenging or painful for most, so it often gets skipped or deferred until late in the development cycle.
Most often, the security tests are executed by a team having a different mindset, bandwidth and cadence from the development team who wants to release the software.

These conditions often foment culture clashes, mistrust and dysfunction between different teams. Quality suffers, operations staff is stressed, deadlines missed and the customer does not get a fully tested product.

This should not be!

Security is everyone's responsibility; not just security or operations.

My short talk will focus on a prototype pipeline that demonstrates how to implement automation for basic security tests whenever developers change code. Said pipeline will be built using open source tools, one or more reference applications (SUTs) and be packaged in a way that makes it easy for attendees to replicate the results onsite in their own environments.

Attendees will come away with better understanding of
 - different types of security tests

 - what should be automated

 - what should *not* be automated

 - how security testing fits into the developer work flow as well as larger project

Any development team can become collaborators with their company's security and operations teams. This talk explores just one of many ways this could happen.
