---
title: Consistent Technical Documents Using Emacs and Org Mode
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/664
beginning: '2019-11-15T13:30:00.000-08:00'
end: '2019-11-15T14:20:00.000-08:00'
presenters:
- name: Mike Hamrick
  osem_url: https://osem.seagl.org/users/365
  gravatar_id: bc4d151e146fc57fa0bb22ef3743bb81
  biography: I've been a fan and user of GNU/Linux since the mid 90s. In my professional
    career I've been a programmer, systems administrator, and DBA. I really enjoy
    finding bugs and solving performance problems using a variety of debugging tools
    and techniques. I also enjoy programming in C, Python, Go, Perl, and Elisp.
---

When writing about programming or other technical subjects, you're often weaving blocks of source code, program output, and raw data in with your prose. These supplementary materials are usually copied and pasted into your document from other sources, which can be difficult and tedious to keep up-to-date as things change. Inconsistencies and errors can easily creep in when you "hard-code" dynamic information like program output into your writing.

Wouldn't it be great if the tool you used for writing knew how to run code in a variety of programming languages, collect and format output, and let you refer symbolically to all this dynamically generated content in your prose? In this talk I'll demonstrate how to use GNU Emacs' _Org mode_ to create professional looking technical documents that do just that. We'll explore the features of Babel, Org mode's literate programming add-on, that makes it convenient to edit, evaluate, and manage embedded code, output, and data all from inside GNU Emacs.
