---
title: Building Custom Linux Systems with Yocto
osem_url: https://osem.seagl.org/conferences/seagl2019/program/proposals/632
beginning: '2019-11-15T15:15:00.000-08:00'
end: '2019-11-15T16:05:00.000-08:00'
resources:
  internet_archive_identifier: yocto
presenters:
- name: Robert Joslyn
  osem_url: https://osem.seagl.org/users/910
  gravatar_id: ea0509f59758bb9d35634e75573fe8c0
  biography: Robert is a software engineer at Schweitzer Engineering Laboratories
    where he helps build and maintain Linux systems used in critical infrastructure
    and industrial automation. Robert is passionate about free software and embedded
    systems, and enjoys working at the boundary between software and hardware. Robert
    has a degree in Electrical Engineering from Rochester Institute of Technology.
---

Have the need to build a custom Linux system for your next project? Are off-the-shelf distros too bloated or not giving the control you want? The Yocto Project provides a set of tools that make it easy to develop a custom Linux distribution tailored to your specific needs. Whether you're building an embedded IoT device, a high performance appliance, or even Docker containers, you can use Yocto to develop, cross-compile, and audit every aspect of your custom Linux system.

This talk introduces Yocto and demonstrates common use cases and customization, including simple builds, adding and removing packages, customizing packages, building for multiple hardware platforms, and changing core functionality such as switching between SysVinit and systemd. We will also discuss methods of auditing the build output to help ensure the only the expected changes are present when updating a build.
