---
title: Take Back Your Data
osem_url: https://osem.seagl.org/conferences/seagl2018/program/proposals/510
beginning: '2018-11-10T16:00:00.000-08:00'
end: '2018-11-10T16:20:00.000-08:00'
resources:
  slides_url: https://andschwa.com/public/Take_Back_Your_Data.pdf
presenters:
- name: Andy Schwartzmeyer
  osem_url: https://osem.seagl.org/users/430
  gravatar_id: a0f86f38a2770f3ec0bbb1ef07f2d31b
  biography: I am a free software and privacy rights advocate living in Seattle, WA.
    I have given a talk at MesosCon for my work done at Microsoft on Apache Mesos,
    and also a talk at Reflections|Projections on how to work in open source, even
    when working in the industry. I contribute to a number of open-source projects,
    and personally license my own code under the GNU licenses. Also, I am an Emacs
    user.
---

This talk is aimed at those with a beginner to intermediate level of experience using technology, and falls under the category of (personal) "Information Security."

In today's world, users have lost control over their personal data. A massive industry has been created by companies such as Google, Amazon, Facebook, Microsoft, and others where the product is _you_: your likes, dislikes, behaviors, interests, social circles, emails, instant messages, location, face, voice, medical problems, and anything else that is entered into a phone or computer. These companies have convinced people, often unknowingly, to give them their most personal (and valuable) data, which they sell to other companies for incredible profits. The users do not know who ends up with their data, nor how it is used, but fortunately users are becoming aware of this as a problem.

The first few minutes of this talk would cover what the problem is, and why users should care; however, I believe the majority of the audience will already want to protect their data. The rest of the talk will cover in some detail how to keep data in your own hands: switching to privacy-conscious alternatives for email, search, browsers, and messengers; blocking trackers and avoiding insecure connections; disabling operating system analytics and microphones; and using a password manager to compartmentalize login information. While this topic is incredibly broad, my talk would aim to cover the most impactful (and easiest) steps thoroughly, and follow it with references to more advanced steps. I would end with pointers to the EFF's Surveillance Self-Defense project and DuckDuckGo's privacy blog.

For steps such as installing and configuring uBlock Origin and HTTPS Everywhere in Firefox, I would do a quick demo, with a sidenote that the same can be done on Android, and that alternatives such as Privacy Badger and DuckDuckGo Privacy Essentials exist. For steps such as using a VPN, I would explain the what and why, with references to some known good providers, the caveats of their use, and the availability of WireGuard for better mobile VPN support. For steps such as switching to alternatives such as Posteo or ProtonMail, DuckDuckGo, and Signal I would only briefly cover their existence and alternatives, as a demo is not required.

The goals I would like to achieve with this talk are: (1) increase the audience's awareness of their potential data leaks; (2) enable some of the audience to take their first steps to keep their data safe; and (3) leave the audience with more tools to secure their personal information.
