---
title: Easy Microservices with Python, Flask, and Docker
osem_url: https://osem.seagl.org/conferences/seagl2018/program/proposals/501
beginning: '2018-11-09T13:30:00.000-08:00'
end: '2018-11-09T14:20:00.000-08:00'
presenters:
- name: Hailey Buckingham
  affiliation: Cylance
  osem_url: https://osem.seagl.org/users/775
  gravatar_id: 2a2c3684aa1a62c192d01c29d1a56d37
  biography: Hailey is a Data Scientist at Cylance (Portland, OR office). She develops
    machine learning models for detecting malware and malicious process behavior,
    and specializes in automated data and ML pipelines and microservices. Much of
    her work is cross-functional and collaborative with non-data science teams.
---

This talk will give an overview of how to quickly build and deploy **RESTful microservices** using **Python**, **Flask**, and **Docker**. These open source tools make it very easy to build scalable microservices that are easy to write and maintain, and that can be quickly deployed in most linux (and linux-related) environments.

We'll cover the following:

1. Using Flask to build a basic python web application
2. Hosting our app locally with gunicorn, an open source WSGI server
3. Writing a simple Dockerfile
4. Using our Dockerfile to containerize our service
5. Host our service locally using docker
6. See a demo of how to deploy our docker image to a cloud instance and see it hosting our service.

Participants will gain a cursory overview of the techniques needed to get started with microservices on these platforms, and will be able to access all the source code on github after the talk as well.
