---
title: Client Side Video Editing - Lessons in WebAssembly and FFmpeg
osem_url: https://osem.seagl.org/conferences/seagl2018/program/proposals/465
beginning: '2018-11-10T15:00:00.000-08:00'
end: '2018-11-10T15:50:00.000-08:00'
presenters:
- name: Megan Slater
  affiliation: GenUI
  osem_url: https://osem.seagl.org/users/757
  gravatar_id: e62fa9e14d0b5dc85f7b54a79e809994
  biography: Megan Slater is the Lead Developer in Community Outreach at GenUI in
    Seattle. She has spent the past 3 years as a web developer working with technologies
    like React, Ember.js and Node. Megan spent time in an earlier life working in
    the investment industry and as a classically trained musician. She leverages her
    experience in multiple fields to encourage great communication and alternate modes
    of problem solving. Megan also serves on the leadership committee of the Seattle
    chapter for Write/Speak/Code (WSC). WSC is an organization that is on a mission
    to increase the visibility and leadership of women and non-binary coders through
    thought leadership, conference speaking, open source contributions, career development,
    personal growth and self-care.
---

There's a lot of hype about the potentials of WebAssembly in the browser right now. It elicits hopes about everything from importing new functionalities into browser based applications, to the potential (and in some circles hoped for) death of JavaScript. This talk is for folks who are curious about the real world applications and limitations of WebAssembly as it exists today. Or perhaps for individuals who have written a thing or two using WebAssembly but are now wondering how to implement major features in more complex environments. I’d like to invite listeners to come follow along the journey of some intrepid developers as they integrate the popular FFmpeg multimedia framework into a React application. I’ll discuss the various complications in conversion, and why many WebAssembly ports are not currently as simple to use as an `npm install`. By the end of the talk, we’ll have created a road map for how to get started adding serious functionality to an application through WebAssembly. I’ll also cover how much time to budget for getting started, some potential pitfalls, and some tips and tricks for porting over large, complicated libraries.
