---
title: Basic Licensing Considerations and Compliance for Projects and Companies
osem_url: https://osem.seagl.org/conferences/seagl2018/program/proposals/541
beginning: '2018-11-09T10:45:00.000-08:00'
end: '2018-11-09T11:35:00.000-08:00'
presenters:
- name: Paul Berg
  affiliation: Paul W Berg Consulting
  osem_url: https://osem.seagl.org/users/309
  gravatar_id: 1592dd3d80fe3ea6dc2b557ab59da458
  biography: Paul Berg is an independent consultant specializing in software licensing.
    He has served as Idaho National Laboratory’s senior research and development software
    licensing manager where he drove the software release strategy for the lab. Before
    coming to INL in 2016, he was a senior open source and software engineer at Amazon.com,
    helping lead the team that designed the logistics strategies and algorithms for
    Amazon’s shipping and delivery systems, and design and drive Amazon’s Open Source
    strategy. As a senior software development engineer at Microsoft, he was in charge
    of pioneering the Office Genuine Advantage system, as well as collaborating on
    Windows and SQL Server development. He has led or collaborated on projects that
    have resulted in 16 patents. He worked extensively with merger and acquisition
    diligence in the technology field and is particularly interested in artificial
    intelligence research, programming language theory and intellectual property strategy.
---

Technology projects do not happen in isolation and often interface with, include or have dependencies on a plethora of other projects which may be licensed under a variety of Open Source, Libre or even proprietary licenses, and possibly include even patent and trademark concerns. Ensuring that a project is compliant with the requirements of all of these licenses can seem like a daunting proposition, but turning a blind eye to the issue can put both the project and its consumers at legal risk or cause rifts in the community if other projects feel their licenses are not being given proper consideration.

Large projects and companies often maintain specialists in this area in order to stay on top of things. Such specialists are probably outside of the reach and budget of smaller projects and companies, but there are best practices and a baseline of knowledge available that can be sufficient for most cases.

We will discuss:

1. The reasons for licensing your project properly and appropriately for your project's goals.

2. Basic best practices to minimize the complexity of compliance as your project grows.

3. The primary concerns around licensing issues for your project and those in its ecosystem.

4. How to address conflicts in a productive manner.

5. What you need to do in order to reasonably achieve and maintain compliance with a minimum of bookkeeping and effort.

6. When and how to seek advice when you need it.
