---
title: Distributed Systems With Docker Swarm
osem_url: https://osem.seagl.org/conferences/seagl2017/program/proposals/351
beginning: '2017-10-06T14:00:00.000-07:00'
end: '2017-10-06T14:50:00.000-07:00'
presenters:
- name: James Cooper
  osem_url: https://osem.seagl.org/users/615
  gravatar_id: 51526dd8566f5def7a227e93daf05de3
  biography: James has been writing software for over 20 years. When not in front
    of a computer, you might find him cooking vegetarian food, waiting on his cats,
    or traveling.
---

Recent versions of Docker support a clustering feature called swarm.
Swarm allows a set of machines running Docker to form a cluster.
Together with Docker Compose, swarm simplifies the task of deploying
a set of services to multiple hosts and provides DNS based service
discovery and load balancing without the need to run additional software.

During this talk you'll learn how to:

* Package applications as docker images
* Deploy multiple containers together using compose
* Use swarm mode to communicate between containers
* Scale your system to multiple machines

A full demo of the running system will be included.

This talk assumes basic knowledge of Linux, but does not assume
prior experience with containers. A GitHub repo with all source
code referenced during the talk will be provided.
