---
title: Clojure for Unix Hackers
osem_url: https://osem.seagl.org/conferences/seagl2017/program/proposals/392
beginning: '2017-10-06T10:45:00.000-07:00'
end: '2017-10-06T11:35:00.000-07:00'
presenters:
- name: Wes Payne
  affiliation: Jupiter Broadcasting
  osem_url: https://osem.seagl.org/users/610
  gravatar_id: f2fcddb941dcf0276ab31cf9a45b5c6f
  biography: Linux and Open Source enthusiast. Aspiring Clojurian and functional programmer.
    Physics and Math nerd. Co-host of Linux Unplugged and TechSNAP. Interested in
    Tech, FOSS, Linux, BSD, DevOps, Automation, AI/ML, Optimization, FP, CLI, Podcasts.
---

### Intended Audience
Unix hackers, sysadmins, and developers; especially those skeptical of the JVM and node.js. Anyone interested in functional programming, lisps, or data oriented programming.

### Audience Takeaways
- Basic understanding of Clojure and functional programming
- Appreciation of sympathetic philosophies between Unix and Clojure
- Introduction to scripting with Clojurescript

### Motivation
Clojure is a modern functional, expressive, and data-oriented lisp. However it runs atop the JVM, CLR, and Javascript runtimes. Sometimes seen as bloated, slow, and "something we have to install for developers", this talk aims to show that not only is Clojure(script) fun, performant, and pragmatic, but it also has a lot in common with Unix and can be a useful tool for scripting, server-side development, UI work, and more!

### Outline
#### Intro to Clojure
- Intro and motivation
- Brief history of Lisp
- Whirlwind tour of Clojure
- Functional Programming

#### Comparisons to Unix
- REPL driven development
- Data oriented programming
- Pipelines and unix philosophy

#### Scripting with Clojurescript
- Intro to Clojurescript
- Bootstrapped Clojurescript and Planck/Lumo
- Script Examples

#### Beyond Scripting
- Browser
- Electron
- Server
- React Native

#### Conclusion and References
