---
title: What are Observables and Why Should I Care?
osem_url: https://osem.seagl.org/conferences/seagl2016/program/proposals/176
beginning: '2016-11-11T15:30:00.000-08:00'
end: '2016-11-11T16:30:00.000-08:00'
presenters:
- name: Randall Koutnik
  affiliation: Netflix.  Chaotic Good
  osem_url: https://osem.seagl.org/users/359
  gravatar_id: 8f10852a80ca4794f50a304254cb123b
  biography: |-
    Randall is a senior engineer at Netflix, building tools that wake up other Netflixers when things break.  To offset that karma, he’s adopted a cat that wakes him up at night whenever a new JavaScript framework is released.

    You can find his words in written form at <https://rkoutnik.com/>
---

If you write JavaScript and have ever struggled with managing data flows or herding piles of asynchronous events, this talk is for you.  Learn about the next generation of asynchronous abstraction: Observables. Born of a cross between the Observer & Iterator patterns, observables are being used everywhere, from Angular 2 to the data teams at Netflix & Microsoft.  In a world where everything is asynchronous, observables have become the perfect tool to tame your wild data flows.

We’ll talk at a high level about why observables stand out among the many asynchronous abstractions available to you.  Then we’ll dive into two case studies in Observable use.  Learn how to conceptualize event streams as simple observable flows when tackling typeaheads on the frontend.  Then, dive into the world of machine learning and see how observables can be used for stream processing.

You'll walk out with the confidence to harness the power of observables to straighten out the asynchronous apocalypse of modern development.
