---
title: 'Concise GNU Bash: An Introduction to Advanced Usage'
osem_url: https://osem.seagl.org/conferences/seagl2016/program/proposals/196
beginning: '2016-11-12T15:30:00.000-08:00'
end: '2016-11-12T16:30:00.000-08:00'
resources:
  slides_url: http://talk.jpnc.info/bash_seagl_2016.pdf
presenters:
- name: James Pannacciulli
  affiliation: Media Temple
  osem_url: https://osem.seagl.org/users/368
  gravatar_id: a3acb0f666a5b74c45c71f9a7e33cafa
  biography: James Pannacciulli is employed as a Systems Engineer at Media Temple,
    where his responsibilities include managing and coding for thousands of machines
    hosting customer sites or providing internal services. He is a strong proponent
    of free/libre software, with other interests including natural language, entomophagy,
    and brewing. James has presented on Bash usage at SCALE, OSCON, and LinuxCon Europe.
---

A fast paced, broad (but not too shallow) introduction to Bash features for users familiar with command line environments who want to go beyond simple command execution.  Exciting concepts and syntax illustrated in the slides and demonstrated with live examples.

Topics include command types, parameters (arguments, variables, arrays, special parameters), parameter expansion (interpolation, directly or with truncation or substitution), stream redirection, compound commands (loops, groups, conditionals), subshells, brace expansion (word and sequence generation), tests and pattern matching, branching (if, case, logical operators), functions, and the encapsulation of parameters and functions for expansion into distinct Bash instances (run your functions in a root shell or on remote hosts via SSH).  Throughout the talk, topics covered are combined to demonstrate higher level constructions and abstractions.

The focus remains on Bash itself, as opposed to commands one might run from Bash (many of which could easily be entire talks on their own).  In the face of a rapidly changing tapestry of free software that runs on our computers and defines the internet, Bash has been a constant and reliable system component for software and systems operations, integration, testing, and prototyping.  Whether you are an administrator, engineer, developer, or user, you are certain to see something in this talk which can be used to improve your work flows and tooling.
