---
title: A Technology Time Travel Trip - Or What I Learned Implementing A Technology
  Base From The Early 1970's
osem_url: https://osem.seagl.org/conferences/seagl2016/program/proposals/132
beginning: '2016-11-11T10:45:00.000-08:00'
end: '2016-11-11T11:45:00.000-08:00'
presenters:
- name: Joseph J. Simpson
  affiliation: Systems Concepts
  osem_url: https://osem.seagl.org/users/327
  gravatar_id: 8aaaa67257f61de0c6537b5c24e27a81
  biography: Joseph J. Simpson’s experience and interests are focused in the area
    of complex systems, system science, systems thinking and systems management.  Joseph
    has professional experience in several domain areas including environmental restoration,
    information systems, systems security, aerospace and defense.  His current activities
    and research interests are associated with complex systems modeling, complexity
    reduction, evolutionary programming, the development of a systems engineering
    language, and organizational assessment and improvement.
---

Prior to the mid 1980's, networks and computers were expensive and limited to a few people.  From the late 1960's to the late 1970's a small group of individuals created a networked, group-based complex problem solving process that is directly dependent on online computer support and network connectivity.  A small number of monographs, that describe the basic process, were written and published by The Battelle Memorial Institute in the early 1970's.  The mathematics and algorithms were given for various components of this complexity reduction process.  However, at this time in the development of computer technology there were no standard compliers, languages or network approaches.

Over the past two or three years, open source software and systems have been used to verify and validate the information provided in these monographs and other publications.  The Symbolic Algebra Graphic Environment (SAGE) from the University of Washington is one open source tool used to evaluate the information and process.  Python and Javascript systems have also been developed to implement the mathematics and process detailed in the publications.

There are a number of existing closed source implementations of these complexity reduction techniques, but individuals find it difficult to place their trust in a code base that they do not have access to and can not evaluate the code.  Therefore, an open source testbed initiative was started to create a standard, open-source code base that will be used to test and evaluate the performance of the closed source systems.  There are a few groups around the world that use these closed source systems, however they are getting uncomfortable because the software is such an important part of the complexity reduction approach.

With a properly implemented set of open source technology combined with the ubiquitous availability of network connectivity, some groups are looking to use this technology to implement digital democracy projects.  The open source philosophy, ethics and transparency are necessary factors that lead to a clear understanding of the software function and validity.

The primary open source components used to move the current project to its current state will be discussed along with the open source code that is being created for future use.
