---
title: How to Train Your Compiler
osem_url: https://osem.seagl.org/conferences/seagl2015/program/proposals/43
beginning: '2015-10-24T13:30:00.000-07:00'
end: '2015-10-24T14:20:00.000-07:00'
resources:
  slides_url: https://github.com/iankronquist/how-to-train-your-compiler
presenters:
- name: Ian Kronquist
  affiliation: The Open Source Lab
  osem_url: https://osem.seagl.org/users/39
  gravatar_id: 88cbebe98c68a47d5f4515199b01f2ab
  biography: Ian Kronquist is a Senior at Oregon State University studying Computer
    Science. During the school year he works at the Open Source Lab as a developer.
    The Summer of 2015 he interned at Puppet Labs on the Puppet Language team. In
    his spare time he enjoys reading, cooking, and contributing to open source projects.
---

You probably use a compiler or an interpreter every day, but do you know how they work? The first compilers were designed more than 60 years ago, but writing a compiler is still viewed as a challenge. However, brave knight, do not fear! Equipped with modern tools and theory we can slay the dragon! Along your journey you will likely gain insights about the trade offs made during the design and implementation of your favorite language.

We'll look at the major components of compilers and interpreters and the theory behind their design. First we'll discuss compilers and the difference between the compiler's front end and back end with examples in simple C code. We'll explain the process of lexing, parsing, and machine code generation, and some common analysis techniques and optimizations. Then we'll examine interpreters through the lens of Python and compare and contrast different designs. We'll look at the trade offs made during interpretation and compilation and how they will affect the code you write.

This talk has been presented at Beaver BarCamp in April, 2015 and is being
further refined.
